try:
	from zcrmsdk.src.com.zoho.crm.api.parameter_map import ParameterMap
	from zcrmsdk.src.com.zoho.crm.api.util import APIResponse, CommonAPIHandler, Utility, Constants
	from zcrmsdk.src.com.zoho.crm.api.param import Param
	from zcrmsdk.src.com.zoho.api.exception import SDKException
	from zcrmsdk.src.com.zoho.crm.api.header import Header
	from zcrmsdk.src.com.zoho.crm.api.header_map import HeaderMap
except Exception:
	from ..parameter_map import ParameterMap
	from ..util import APIResponse, CommonAPIHandler, Utility, Constants
	from ..param import Param
	from zcrmsdk.src.com.zoho.api.exception import SDKException
	from ..header import Header
	from ..header_map import HeaderMap


class RelatedRecordsOperations(object):
	def __init__(self, module_api_name, record_id, related_list_api_name):
		"""
		Creates an instance of RelatedRecordsOperations with the given parameters

		Parameters:
			module_api_name (string) : A string value
			record_id (string) : A string value
			related_list_api_name (string) : A string value
		"""

		if not isinstance(module_api_name, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: module_api_name EXPECTED TYPE: str', None, None)
		
		if not isinstance(record_id, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: record_id EXPECTED TYPE: str', None, None)
		
		if not isinstance(related_list_api_name, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: related_list_api_name EXPECTED TYPE: str', None, None)
		
		self.__module_api_name = module_api_name
		self.__record_id = record_id
		self.__related_list_api_name = related_list_api_name


	def get_related_records(self, param_instance, header_instance):
		"""
		The method to get related records

		Parameters:
			param_instance (ParameterMap) : An instance of ParameterMap
			header_instance (HeaderMap) : An instance of HeaderMap

		Returns:
			APIResponse: An instance of APIResponse
		"""

		if param_instance is not None and not isinstance(param_instance, ParameterMap):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: param_instance EXPECTED TYPE: ParameterMap', None, None)
		
		if header_instance is not None and not isinstance(header_instance, HeaderMap):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: header_instance EXPECTED TYPE: HeaderMap', None, None)
		
		handler_instance = CommonAPIHandler()
		api_path = ''
		api_path = api_path + '/crm/v2/'
		api_path = api_path + str(self.__module_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(self.__record_id)
		api_path = api_path + '/'
		api_path = api_path + str(self.__related_list_api_name)
		handler_instance.api_path = api_path
		handler_instance.http_method = Constants.REQUEST_METHOD_GET
		handler_instance.param = param_instance
		handler_instance.header = header_instance
		Utility.get_related_lists(self.__related_list_api_name, self.__module_api_name, handler_instance)
		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.response_handler import ResponseHandler
		except Exception:
			from .response_handler import ResponseHandler
		return handler_instance.api_call(ResponseHandler.__module__, 'application/json')

	def update_related_records(self, request):
		"""
		The method to update related records

		Parameters:
			request (BodyWrapper) : An instance of BodyWrapper

		Returns:
			APIResponse: An instance of APIResponse
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.body_wrapper import BodyWrapper
		except Exception:
			from .body_wrapper import BodyWrapper

		if not isinstance(request, BodyWrapper):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: request EXPECTED TYPE: BodyWrapper', None, None)
		
		handler_instance = CommonAPIHandler()
		api_path = ''
		api_path = api_path + '/crm/v2/'
		api_path = api_path + str(self.__module_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(self.__record_id)
		api_path = api_path + '/'
		api_path = api_path + str(self.__related_list_api_name)
		handler_instance.api_path = api_path
		handler_instance.http_method = Constants.REQUEST_METHOD_PUT
		handler_instance.content_type = 'application/json'
		handler_instance.request = request
		Utility.get_related_lists(self.__related_list_api_name, self.__module_api_name, handler_instance)
		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.action_handler import ActionHandler
		except Exception:
			from .action_handler import ActionHandler
		return handler_instance.api_call(ActionHandler.__module__, 'application/json')

	def delink_records(self, param_instance):
		"""
		The method to delink records

		Parameters:
			param_instance (ParameterMap) : An instance of ParameterMap

		Returns:
			APIResponse: An instance of APIResponse
		"""

		if param_instance is not None and not isinstance(param_instance, ParameterMap):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: param_instance EXPECTED TYPE: ParameterMap', None, None)
		
		handler_instance = CommonAPIHandler()
		api_path = ''
		api_path = api_path + '/crm/v2/'
		api_path = api_path + str(self.__module_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(self.__record_id)
		api_path = api_path + '/'
		api_path = api_path + str(self.__related_list_api_name)
		handler_instance.api_path = api_path
		handler_instance.http_method = Constants.REQUEST_METHOD_DELETE
		handler_instance.param = param_instance
		Utility.get_related_lists(self.__related_list_api_name, self.__module_api_name, handler_instance)
		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.action_handler import ActionHandler
		except Exception:
			from .action_handler import ActionHandler
		return handler_instance.api_call(ActionHandler.__module__, 'application/json')

	def get_related_record(self, header_instance, related_record_id):
		"""
		The method to get related record

		Parameters:
			header_instance (HeaderMap) : An instance of HeaderMap
			related_record_id (string) : A string value

		Returns:
			APIResponse: An instance of APIResponse
		"""

		if header_instance is not None and not isinstance(header_instance, HeaderMap):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: header_instance EXPECTED TYPE: HeaderMap', None, None)
		
		if not isinstance(related_record_id, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: related_record_id EXPECTED TYPE: str', None, None)
		
		handler_instance = CommonAPIHandler()
		api_path = ''
		api_path = api_path + '/crm/v2/'
		api_path = api_path + str(self.__module_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(self.__record_id)
		api_path = api_path + '/'
		api_path = api_path + str(self.__related_list_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(related_record_id)
		handler_instance.api_path = api_path
		handler_instance.http_method = Constants.REQUEST_METHOD_GET
		handler_instance.header = header_instance
		Utility.get_related_lists(self.__related_list_api_name, self.__module_api_name, handler_instance)
		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.response_handler import ResponseHandler
		except Exception:
			from .response_handler import ResponseHandler
		return handler_instance.api_call(ResponseHandler.__module__, 'application/json')

	def update_related_record(self, request, related_record_id):
		"""
		The method to update related record

		Parameters:
			request (BodyWrapper) : An instance of BodyWrapper
			related_record_id (string) : A string value

		Returns:
			APIResponse: An instance of APIResponse
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.body_wrapper import BodyWrapper
		except Exception:
			from .body_wrapper import BodyWrapper

		if not isinstance(request, BodyWrapper):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: request EXPECTED TYPE: BodyWrapper', None, None)
		
		if not isinstance(related_record_id, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: related_record_id EXPECTED TYPE: str', None, None)
		
		handler_instance = CommonAPIHandler()
		api_path = ''
		api_path = api_path + '/crm/v2/'
		api_path = api_path + str(self.__module_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(self.__record_id)
		api_path = api_path + '/'
		api_path = api_path + str(self.__related_list_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(related_record_id)
		handler_instance.api_path = api_path
		handler_instance.http_method = Constants.REQUEST_METHOD_PUT
		handler_instance.content_type = 'application/json'
		handler_instance.request = request
		Utility.get_related_lists(self.__related_list_api_name, self.__module_api_name, handler_instance)
		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.action_handler import ActionHandler
		except Exception:
			from .action_handler import ActionHandler
		return handler_instance.api_call(ActionHandler.__module__, 'application/json')

	def delink_record(self, related_record_id):
		"""
		The method to delink record

		Parameters:
			related_record_id (string) : A string value

		Returns:
			APIResponse: An instance of APIResponse
		"""

		if not isinstance(related_record_id, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: related_record_id EXPECTED TYPE: str', None, None)
		
		handler_instance = CommonAPIHandler()
		api_path = ''
		api_path = api_path + '/crm/v2/'
		api_path = api_path + str(self.__module_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(self.__record_id)
		api_path = api_path + '/'
		api_path = api_path + str(self.__related_list_api_name)
		api_path = api_path + '/'
		api_path = api_path + str(related_record_id)
		handler_instance.api_path = api_path
		handler_instance.http_method = Constants.REQUEST_METHOD_DELETE
		Utility.get_related_lists(self.__related_list_api_name, self.__module_api_name, handler_instance)
		try:
			from zcrmsdk.src.com.zoho.crm.api.related_records.action_handler import ActionHandler
		except Exception:
			from .action_handler import ActionHandler
		return handler_instance.api_call(ActionHandler.__module__, 'application/json')


class GetRelatedRecordsParam(object):
	page = Param('page', 'com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam')

	per_page = Param('per_page', 'com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam')


class GetRelatedRecordsHeader(object):
	if_modified_since = Header('If-Modified-Since', 'com.zoho.crm.api.RelatedRecords.GetRelatedRecordsHeader')


class DelinkRecordsParam(object):
	ids = Param('ids', 'com.zoho.crm.api.RelatedRecords.DelinkRecordsParam')


class GetRelatedRecordHeader(object):
	if_modified_since = Header('If-Modified-Since', 'com.zoho.crm.api.RelatedRecords.GetRelatedRecordHeader')

