try:
	from zcrmsdk.src.com.zoho.crm.api.util import Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException
except Exception:
	from ..util import Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException


class Info(object):
	def __init__(self):
		"""Creates an instance of Info"""

		self.__per_page = None
		self.__default = None
		self.__count = None
		self.__page = None
		self.__more_records = None
		self.__translation = None
		self.__key_modified = dict()

	def get_per_page(self):
		"""
		The method to get the per_page

		Returns:
			int: A int value
		"""

		return self.__per_page

	def set_per_page(self, per_page):
		"""
		The method to set the value to per_page

		Parameters:
			per_page (int) : A int value
		"""

		if not isinstance(per_page, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: per_page EXPECTED TYPE: int', None, None)
		
		self.__per_page = per_page
		self.__key_modified['per_page'] = 1

	def get_default(self):
		"""
		The method to get the default

		Returns:
			string: A string value
		"""

		return self.__default

	def set_default(self, default):
		"""
		The method to set the value to default

		Parameters:
			default (string) : A string value
		"""

		if not isinstance(default, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: default EXPECTED TYPE: str', None, None)
		
		self.__default = default
		self.__key_modified['default'] = 1

	def get_count(self):
		"""
		The method to get the count

		Returns:
			int: A int value
		"""

		return self.__count

	def set_count(self, count):
		"""
		The method to set the value to count

		Parameters:
			count (int) : A int value
		"""

		if not isinstance(count, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: count EXPECTED TYPE: int', None, None)
		
		self.__count = count
		self.__key_modified['count'] = 1

	def get_page(self):
		"""
		The method to get the page

		Returns:
			int: A int value
		"""

		return self.__page

	def set_page(self, page):
		"""
		The method to set the value to page

		Parameters:
			page (int) : A int value
		"""

		if not isinstance(page, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: page EXPECTED TYPE: int', None, None)
		
		self.__page = page
		self.__key_modified['page'] = 1

	def get_more_records(self):
		"""
		The method to get the more_records

		Returns:
			bool: A bool value
		"""

		return self.__more_records

	def set_more_records(self, more_records):
		"""
		The method to set the value to more_records

		Parameters:
			more_records (bool) : A bool value
		"""

		if not isinstance(more_records, bool):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: more_records EXPECTED TYPE: bool', None, None)
		
		self.__more_records = more_records
		self.__key_modified['more_records'] = 1

	def get_translation(self):
		"""
		The method to get the translation

		Returns:
			Translation: An instance of Translation
		"""

		return self.__translation

	def set_translation(self, translation):
		"""
		The method to set the value to translation

		Parameters:
			translation (Translation) : An instance of Translation
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.custom_views.translation import Translation
		except Exception:
			from .translation import Translation

		if not isinstance(translation, Translation):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: translation EXPECTED TYPE: Translation', None, None)
		
		self.__translation = translation
		self.__key_modified['translation'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string value

		Returns:
			int: A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string value
			modification (int) : A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
