try:
	from zcrmsdk.src.com.zoho.crm.api.util import Choice, Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException
except Exception:
	from ..util import Choice, Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException


class Resource(object):
	def __init__(self):
		"""Creates an instance of Resource"""

		self.__status = None
		self.__type = None
		self.__module = None
		self.__file_id = None
		self.__ignore_empty = None
		self.__find_by = None
		self.__field_mappings = None
		self.__file = None
		self.__key_modified = dict()

	def get_status(self):
		"""
		The method to get the status

		Returns:
			Choice: An instance of Choice
		"""

		return self.__status

	def set_status(self, status):
		"""
		The method to set the value to status

		Parameters:
			status (Choice) : An instance of Choice
		"""

		if not isinstance(status, Choice):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: status EXPECTED TYPE: Choice', None, None)
		
		self.__status = status
		self.__key_modified['status'] = 1

	def get_type(self):
		"""
		The method to get the type

		Returns:
			Choice: An instance of Choice
		"""

		return self.__type

	def set_type(self, type):
		"""
		The method to set the value to type

		Parameters:
			type (Choice) : An instance of Choice
		"""

		if not isinstance(type, Choice):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: type EXPECTED TYPE: Choice', None, None)
		
		self.__type = type
		self.__key_modified['type'] = 1

	def get_module(self):
		"""
		The method to get the module

		Returns:
			string: A string value
		"""

		return self.__module

	def set_module(self, module):
		"""
		The method to set the value to module

		Parameters:
			module (string) : A string value
		"""

		if not isinstance(module, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: module EXPECTED TYPE: str', None, None)
		
		self.__module = module
		self.__key_modified['module'] = 1

	def get_file_id(self):
		"""
		The method to get the file_id

		Returns:
			string: A string value
		"""

		return self.__file_id

	def set_file_id(self, file_id):
		"""
		The method to set the value to file_id

		Parameters:
			file_id (string) : A string value
		"""

		if not isinstance(file_id, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: file_id EXPECTED TYPE: str', None, None)
		
		self.__file_id = file_id
		self.__key_modified['file_id'] = 1

	def get_ignore_empty(self):
		"""
		The method to get the ignore_empty

		Returns:
			bool: A bool value
		"""

		return self.__ignore_empty

	def set_ignore_empty(self, ignore_empty):
		"""
		The method to set the value to ignore_empty

		Parameters:
			ignore_empty (bool) : A bool value
		"""

		if not isinstance(ignore_empty, bool):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: ignore_empty EXPECTED TYPE: bool', None, None)
		
		self.__ignore_empty = ignore_empty
		self.__key_modified['ignore_empty'] = 1

	def get_find_by(self):
		"""
		The method to get the find_by

		Returns:
			string: A string value
		"""

		return self.__find_by

	def set_find_by(self, find_by):
		"""
		The method to set the value to find_by

		Parameters:
			find_by (string) : A string value
		"""

		if not isinstance(find_by, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: find_by EXPECTED TYPE: str', None, None)
		
		self.__find_by = find_by
		self.__key_modified['find_by'] = 1

	def get_field_mappings(self):
		"""
		The method to get the field_mappings

		Returns:
			list: An instance of list
		"""

		return self.__field_mappings

	def set_field_mappings(self, field_mappings):
		"""
		The method to set the value to field_mappings

		Parameters:
			field_mappings (list) : An instance of list
		"""

		if not isinstance(field_mappings, list):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: field_mappings EXPECTED TYPE: list', None, None)
		
		self.__field_mappings = field_mappings
		self.__key_modified['field_mappings'] = 1

	def get_file(self):
		"""
		The method to get the file

		Returns:
			File: An instance of File
		"""

		return self.__file

	def set_file(self, file):
		"""
		The method to set the value to file

		Parameters:
			file (File) : An instance of File
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.bulk_write.file import File
		except Exception:
			from .file import File

		if not isinstance(file, File):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: file EXPECTED TYPE: File', None, None)
		
		self.__file = file
		self.__key_modified['file'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string value

		Returns:
			int: A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string value
			modification (int) : A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
