try:
	from zcrmsdk.src.com.zoho.crm.api.util import Choice, Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException
except Exception:
	from ..util import Choice, Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException


class RequestWrapper(object):
	def __init__(self):
		"""Creates an instance of RequestWrapper"""

		self.__callback = None
		self.__query = None
		self.__file_type = None
		self.__key_modified = dict()

	def get_callback(self):
		"""
		The method to get the callback

		Returns:
			CallBack: An instance of CallBack
		"""

		return self.__callback

	def set_callback(self, callback):
		"""
		The method to set the value to callback

		Parameters:
			callback (CallBack) : An instance of CallBack
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.bulk_read.call_back import CallBack
		except Exception:
			from .call_back import CallBack

		if not isinstance(callback, CallBack):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: callback EXPECTED TYPE: CallBack', None, None)
		
		self.__callback = callback
		self.__key_modified['callback'] = 1

	def get_query(self):
		"""
		The method to get the query

		Returns:
			Query: An instance of Query
		"""

		return self.__query

	def set_query(self, query):
		"""
		The method to set the value to query

		Parameters:
			query (Query) : An instance of Query
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.bulk_read.query import Query
		except Exception:
			from .query import Query

		if not isinstance(query, Query):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: query EXPECTED TYPE: Query', None, None)
		
		self.__query = query
		self.__key_modified['query'] = 1

	def get_file_type(self):
		"""
		The method to get the file_type

		Returns:
			Choice: An instance of Choice
		"""

		return self.__file_type

	def set_file_type(self, file_type):
		"""
		The method to set the value to file_type

		Parameters:
			file_type (Choice) : An instance of Choice
		"""

		if not isinstance(file_type, Choice):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: file_type EXPECTED TYPE: Choice', None, None)
		
		self.__file_type = file_type
		self.__key_modified['file_type'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string value

		Returns:
			int: A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string value
			modification (int) : A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
