<!--
Document Author
Yuta Nakahara <yuta.nakahara@aoni.waseda.jp>
-->
# コントリビューションの方法

まず，BayesMLへのコントリビューションを考え，このページを訪れてくださったことに心から感謝いたします．
このページでは，バグの報告，ドキュメントの修正・翻訳，コードへの貢献方法について記載します．

## BayesMLの公開経緯と理念

はじめに，BayesMLの立ち上げの経緯と理念をご確認ください．BayesMLの目的は，README.mdにあるように，ベイズ統計学やベイズ決定理論に基づく機械学習の研究，教育，活用を促進し，社会に広く貢献することです．BayesMLは，もともと我々の研究室の後輩指導を効率化するためにベイズ機械学習に関するコードの実装形式を統一しようという試みでした．しかし，この試みは他の研究者，学生，企業に勤めるデータサイエンティストにとっても有用かもしれません．そこで，BayesMLを公開することにしました．

こうした経緯があるため，BayesMLでは教育的な側面を非常に重視しています．我々は，利用者，コントリビュータの皆さんがBayesMLとの関わりの中でベイズ統計学，ベイズ決定理論に基づく機械学習に対する理解を深め，それを学術界や産業界など社会の様々な場所に活用してくれることを願っています．BayesMLに対するあらゆるコントリビューションはこの理念のもとにレビューされます．もし仮にあなたのコントリビューションが採用されなかったとしても，それは考え方の相違であって，コントリビューションそのものの価値を否定するものではないということをご理解いただければ幸いです．

また，[こちら](./CODE_OF_CONDUCT.md)の行動規範についてもご一読ください．

## バグの報告方法

バグを発見された方は，以下の形式でイシューの作成をお願いいたします．

* 実行環境
  * OS
  * Pythonやライブラリのバージョン
* 実行内容
* 期待された結果
* 実際の結果

## ドキュメントの修正・翻訳方法

タイポや文法上の誤りなどの軽微なものについては，以下の形式でイシューの作成をお願いいたします．

* URL
* 誤った記述
* 正しい記述

大規模な修正，翻訳にご協力頂ける方は，形式は指定しませんのでイシューの作成を通じてご連絡ください．特に，開発者向けの資料の大部分は日本語で執筆されているため，これらの翻訳をお願いできる方を歓迎いたします．

## コードへの貢献方法

申し訳ございませんが，現在，開発者と直接面識のない方からのコードへの貢献は受け付けておりません．主な理由は以下の通りです．

* 今後，実装予定の変分ベイズ系アルゴリズムの実装形式が統一されていない
* 開発者向けのドキュメントが整備されていない
* 開発者がOSSプロジェクトとしての開発に不慣れである

これらの問題が解決され次第，コードへの貢献を募集させていただければと思います．その場合にも，BayesMLの開発理念に基づく議論が必要となる可能性があるということをご了承いただければと思います．
