import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy#description SentinelPolicy#description}
    */
    readonly description?: string;
    /**
    * Specifies the enforcement level of the policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy#enforcement_level SentinelPolicy#enforcement_level}
    */
    readonly enforcementLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy#id SentinelPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy#name SentinelPolicy#name}
    */
    readonly name: string;
    /**
    * The Sentinel policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy#policy SentinelPolicy#policy}
    */
    readonly policy: string;
    /**
    * Specifies the scope for this policy. Only 'submit-job' is currently supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy#scope SentinelPolicy#scope}
    */
    readonly scope: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy nomad_sentinel_policy}
*/
export declare class SentinelPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_sentinel_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/sentinel_policy nomad_sentinel_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelPolicyConfig
    */
    constructor(scope: Construct, id: string, config: SentinelPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enforcementLevel?;
    get enforcementLevel(): string;
    set enforcementLevel(value: string);
    get enforcementLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
