import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the token should be replicated to all regions or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#global AclToken#global}
    */
    readonly global?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#id AclToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Human-readable name for this token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#name AclToken#name}
    */
    readonly name?: string;
    /**
    * The ACL policies to associate with the token, if it's a 'client' type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#policies AclToken#policies}
    */
    readonly policies?: string[];
    /**
    * The type of token to create, 'client' or 'management'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#type AclToken#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/acl_token nomad_acl_token}
*/
export declare class AclToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/acl_token nomad_acl_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclTokenConfig
    */
    constructor(scope: Construct, id: string, config: AclTokenConfig);
    get accessorId(): string;
    get createTime(): string;
    private _global?;
    get global(): boolean | cdktf.IResolvable;
    set global(value: boolean | cdktf.IResolvable);
    resetGlobal(): void;
    get globalInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    get secretId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
