![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/logo-350.png)

## A library for exploratory analysis of Time Series data

![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_python.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_build.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_docs.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_tests.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_coverage.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_lint.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_mypy.svg)
![](https://raw.githubusercontent.com/hsbc/tslumen/main/doc/source/_static/badge_style.svg)


**tslumen** helps bring to light the key characteristics of your time
series data with rich, pre-canned artifacts, packed with charts and
statistical information. The primary goal of tslumen is to expedite and
bring consistency to how time series EDA is performed, allowing you to
uncover the fundamental aspects in seconds rather than hours or days.

**Key features**
 * Platform agnostic, integrates nicely with your datascience workspace
 * Built on open source technology and research
 * Highly customizable and extensible
 * Data (profiling results) completely detached from the visuals
 * Can be executed from the command line
 * Efficient execution using parallel processing
 * Includes a great number of statistical information, including descriptive statistics statistical tests like KPSS or ADF, correlation, tsfeatures, etc.
 * Various plots specifically tailored to time series analysis
 * Self-contained HTML report that can easily be shared with interested parties
 * Fully interactive dashboard for a richer experience and detailed exploration

See https://hsbc.github.io/tslumen/ for the complete documentation.


## Installation

From PyPI:

```bash
pip install -U tslumen
```

From source:

```bash
# cd into tslumen after cloning the repo
make install
```


## Examples

Refer to the [Quick Start](https://hsbc.github.io/tslumen/html/quickstart.html) 
page of the documentation for a brief tour of the package.

Complete example notebooks can be found on the **User Guide** section of the documentation.


## Contributing

Contributions to tslumen are welcome. Please see our [contribution guide](CONTRIBUTING.md) for more details.


