# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.11.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from intrinio_sdk.api_client import ApiClient


class IndexApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_all_economic_indices(self, **kwargs):  # noqa: E501
        """All Economic Indices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_economic_indices(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseEconomicIndices
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_economic_indices_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_economic_indices_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_economic_indices_with_http_info(self, **kwargs):  # noqa: E501
        """All Economic Indices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_economic_indices_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseEconomicIndices
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_economic_indices" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_all_economic_indices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/economic', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseEconomicIndices',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_sic_indices(self, **kwargs):  # noqa: E501
        """All SIC Indices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_sic_indices(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSICIndices
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_sic_indices_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_sic_indices_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_sic_indices_with_http_info(self, **kwargs):  # noqa: E501
        """All SIC Indices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_sic_indices_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSICIndices
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_sic_indices" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_all_sic_indices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/sic', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSICIndices',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_stock_market_indices(self, **kwargs):  # noqa: E501
        """All Stock Market Indices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_stock_market_indices(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseStockMarketIndices
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_stock_market_indices_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_stock_market_indices_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_stock_market_indices_with_http_info(self, **kwargs):  # noqa: E501
        """All Stock Market Indices  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_stock_market_indices_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseStockMarketIndices
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_stock_market_indices" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_all_stock_market_indices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/stock_market', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseStockMarketIndices',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_economic_index_by_id(self, identifier, **kwargs):  # noqa: E501
        """Lookup Economic Index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_by_id(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :return: EconomicIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_economic_index_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_economic_index_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_economic_index_by_id_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Lookup Economic Index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_by_id_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :return: EconomicIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_economic_index_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_economic_index_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/economic/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EconomicIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_economic_index_data_point_number(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for an Economic Index  # noqa: E501

        Returns a numeric value for the given `tag` for the Economic Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_data_point_number(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag <a href='https://data.intrinio.com/data-tags/economic'>reference</a> (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_economic_index_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_economic_index_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_economic_index_data_point_number_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for an Economic Index  # noqa: E501

        Returns a numeric value for the given `tag` for the Economic Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_data_point_number_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag <a href='https://data.intrinio.com/data-tags/economic'>reference</a> (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_economic_index_data_point_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_economic_index_data_point_number`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_economic_index_data_point_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/economic/{identifier}/data_point/{tag}/number', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='float',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_economic_index_data_point_text(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for an Economic Index  # noqa: E501

        Returns a text value for the given `tag` for the Economic Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_data_point_text(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_economic_index_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_economic_index_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_economic_index_data_point_text_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for an Economic Index  # noqa: E501

        Returns a text value for the given `tag` for the Economic Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_data_point_text_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_economic_index_data_point_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_economic_index_data_point_text`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_economic_index_data_point_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/economic/{identifier}/data_point/{tag}/text', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_economic_index_historical_data(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for an Economic Index  # noqa: E501

        Returns historical values for the given `tag` and the Economic Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_historical_data(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag <a href='https://data.intrinio.com/data-tags/economic'>reference</a> (required)
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseEconomicIndexHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_economic_index_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_economic_index_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_economic_index_historical_data_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for an Economic Index  # noqa: E501

        Returns historical values for the given `tag` and the Economic Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_economic_index_historical_data_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag <a href='https://data.intrinio.com/data-tags/economic'>reference</a> (required)
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseEconomicIndexHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag', 'type', 'start_date', 'end_date', 'sort_order', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_economic_index_historical_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_economic_index_historical_data`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_economic_index_historical_data`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_economic_index_historical_data`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sort_order', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/economic/{identifier}/historical_data/{tag}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseEconomicIndexHistoricalData',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sic_index_by_id(self, identifier, **kwargs):  # noqa: E501
        """Lookup SIC Index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_by_id(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :return: SICIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sic_index_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sic_index_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_sic_index_by_id_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Lookup SIC Index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_by_id_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :return: SICIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sic_index_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_sic_index_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/sic/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SICIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sic_index_data_point_number(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for an SIC Index  # noqa: E501

        Returns a numeric value for the given `tag` for the SIC Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_data_point_number(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sic_index_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sic_index_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_sic_index_data_point_number_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for an SIC Index  # noqa: E501

        Returns a numeric value for the given `tag` for the SIC Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_data_point_number_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sic_index_data_point_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_sic_index_data_point_number`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_sic_index_data_point_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/sic/{identifier}/data_point/{tag}/number', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='float',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sic_index_data_point_text(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for an SIC Index  # noqa: E501

        Returns a text value for the given `tag` for the SIC Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_data_point_text(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sic_index_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sic_index_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_sic_index_data_point_text_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for an SIC Index  # noqa: E501

        Returns a text value for the given `tag` for the SIC Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_data_point_text_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sic_index_data_point_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_sic_index_data_point_text`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_sic_index_data_point_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/sic/{identifier}/data_point/{tag}/text', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sic_index_historical_data(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for an SIC Index  # noqa: E501

        Returns historical values for the given `tag` and the SIC Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_historical_data(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSICIndexHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_sic_index_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sic_index_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_sic_index_historical_data_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for an SIC Index  # noqa: E501

        Returns historical values for the given `tag` and the SIC Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_sic_index_historical_data_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSICIndexHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag', 'type', 'start_date', 'end_date', 'sort_order', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sic_index_historical_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_sic_index_historical_data`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_sic_index_historical_data`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_sic_index_historical_data`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sort_order', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/sic/{identifier}/historical_data/{tag}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSICIndexHistoricalData',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stock_market_index_by_id(self, identifier, **kwargs):  # noqa: E501
        """Lookup Stock Market Index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_by_id(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :return: StockMarketIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_stock_market_index_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_stock_market_index_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_stock_market_index_by_id_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Lookup Stock Market Index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_by_id_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :return: StockMarketIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stock_market_index_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_stock_market_index_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/stock_market/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StockMarketIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stock_market_index_data_point_number(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for Stock Market Index  # noqa: E501

        Returns a numeric value for the given `tag` for the Stock Market Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_data_point_number(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_stock_market_index_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_stock_market_index_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_stock_market_index_data_point_number_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for Stock Market Index  # noqa: E501

        Returns a numeric value for the given `tag` for the Stock Market Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_data_point_number_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stock_market_index_data_point_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_stock_market_index_data_point_number`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_stock_market_index_data_point_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/stock_market/{identifier}/data_point/{tag}/number', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='float',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stock_market_index_data_point_text(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for Stock Market Index  # noqa: E501

        Returns a text value for the given `tag` for the Stock Market Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_data_point_text(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_stock_market_index_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_stock_market_index_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_stock_market_index_data_point_text_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for Stock Market Index  # noqa: E501

        Returns a text value for the given `tag` for the Stock Market Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_data_point_text_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stock_market_index_data_point_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_stock_market_index_data_point_text`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_stock_market_index_data_point_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/stock_market/{identifier}/data_point/{tag}/text', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stock_market_index_historical_data(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for Stock Market Index  # noqa: E501

        Returns historical values for the given `tag` and the Stock Market Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_historical_data(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseStockMarketIndexHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_stock_market_index_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_stock_market_index_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_stock_market_index_historical_data_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for Stock Market Index  # noqa: E501

        Returns historical values for the given `tag` and the Stock Market Index with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_stock_market_index_historical_data_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: An Index Identifier (symbol, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseStockMarketIndexHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag', 'type', 'start_date', 'end_date', 'sort_order', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stock_market_index_historical_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_stock_market_index_historical_data`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_stock_market_index_historical_data`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_stock_market_index_historical_data`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sort_order', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/stock_market/{identifier}/historical_data/{tag}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseStockMarketIndexHistoricalData',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_economic_indices(self, query, **kwargs):  # noqa: E501
        """Search Economic Indices  # noqa: E501

        Searches for indices using the text in `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_economic_indices(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search query (required)
        :param int page_size: The number of results to return
        :return: ApiResponseEconomicIndicesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.search_economic_indices_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_economic_indices_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_economic_indices_with_http_info(self, query, **kwargs):  # noqa: E501
        """Search Economic Indices  # noqa: E501

        Searches for indices using the text in `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_economic_indices_with_http_info(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search query (required)
        :param int page_size: The number of results to return
        :return: ApiResponseEconomicIndicesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_economic_indices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `search_economic_indices`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `search_economic_indices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/economic/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseEconomicIndicesSearch',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_sic_indices(self, query, **kwargs):  # noqa: E501
        """Search SIC Indices  # noqa: E501

        Searches for indices using the text in `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_sic_indices(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search query (required)
        :param int page_size: The number of results to return
        :return: ApiResponseSICIndicesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.search_sic_indices_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_sic_indices_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_sic_indices_with_http_info(self, query, **kwargs):  # noqa: E501
        """Search SIC Indices  # noqa: E501

        Searches for indices using the text in `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_sic_indices_with_http_info(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search query (required)
        :param int page_size: The number of results to return
        :return: ApiResponseSICIndicesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_sic_indices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `search_sic_indices`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `search_sic_indices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/sic/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSICIndicesSearch',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_stock_markets_indices(self, query, **kwargs):  # noqa: E501
        """Search Stock Market Indices  # noqa: E501

        Searches for indices using the text in `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_stock_markets_indices(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search query (required)
        :param int page_size: The number of results to return
        :return: ApiResponseStockMarketIndicesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.search_stock_markets_indices_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_stock_markets_indices_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_stock_markets_indices_with_http_info(self, query, **kwargs):  # noqa: E501
        """Search Stock Market Indices  # noqa: E501

        Searches for indices using the text in `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_stock_markets_indices_with_http_info(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search query (required)
        :param int page_size: The number of results to return
        :return: ApiResponseStockMarketIndicesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_stock_markets_indices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `search_stock_markets_indices`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `search_stock_markets_indices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/indices/stock_market/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseStockMarketIndicesSearch',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
