from typing import Any

from ragang.core.bases.datas.performance import Performance
from ragang.core.decorators.serializable import serializable


@serializable
class Packet:
    def __init__(self, src_mid: str, data: dict[str, object], formed_output: dict[str, dict[str, Any]],
                 performances: list[Performance], x_time: float):
        self.src: str = src_mid  # src_mid
        self.data: dict[str, Any] = data  # {key: value}
        self.formed_output: dict[str, dict[str, Any]] = formed_output  # {dst_mid: dict}
        self.performances: list[Performance] = performances
        self.x_time: float = x_time  # sec
        self.is_answer: bool = 'gen' in data.keys()
