"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeletableBucket = void 0;
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const empty_bucket_1 = require("./empty-bucket");
class DeletableBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props = {}) {
        const { forceDelete = false } = props;
        super(scope, id, {
            removalPolicy: forceDelete ? core_1.RemovalPolicy.DESTROY : undefined,
            ...props,
        });
        if (forceDelete) {
            new empty_bucket_1.EmptyBucket(this, 'EmptyBucket', {
                bucket: this,
            });
        }
    }
}
exports.DeletableBucket = DeletableBucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsZXRhYmxlLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kZWxldGFibGUtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDRDQUFzRDtBQUN0RCx3Q0FBeUQ7QUFFekQsaURBQTZDO0FBVzdDLE1BQWEsZUFBZ0IsU0FBUSxlQUFNO0lBQ3pDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBOEIsRUFBRTtRQUN4RSxNQUFNLEVBQUUsV0FBVyxHQUFHLEtBQUssRUFBRSxHQUFHLEtBQUssQ0FBQztRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLGFBQWEsRUFBRSxXQUFXLENBQUMsQ0FBQyxDQUFDLG9CQUFhLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQzlELEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztRQUVILElBQUksV0FBVyxFQUFFO1lBQ2YsSUFBSSwwQkFBVyxDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7Z0JBQ25DLE1BQU0sRUFBRSxJQUFJO2FBQ2IsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDO0NBQ0Y7QUFkRCwwQ0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJ1Y2tldCwgQnVja2V0UHJvcHMgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBSZW1vdmFsUG9saWN5IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmltcG9ydCB7IEVtcHR5QnVja2V0IH0gZnJvbSAnLi9lbXB0eS1idWNrZXQnO1xuXG5leHBvcnQgaW50ZXJmYWNlIERlbGV0YWJsZUJ1Y2tldFByb3BzIGV4dGVuZHMgQnVja2V0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZvcmNlRGVsZXRlPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIERlbGV0YWJsZUJ1Y2tldCBleHRlbmRzIEJ1Y2tldCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEZWxldGFibGVCdWNrZXRQcm9wcyA9IHt9KSB7XG4gICAgY29uc3QgeyBmb3JjZURlbGV0ZSA9IGZhbHNlIH0gPSBwcm9wcztcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHJlbW92YWxQb2xpY3k6IGZvcmNlRGVsZXRlID8gUmVtb3ZhbFBvbGljeS5ERVNUUk9ZIDogdW5kZWZpbmVkLFxuICAgICAgLi4ucHJvcHMsXG4gICAgfSk7XG5cbiAgICBpZiAoZm9yY2VEZWxldGUpIHtcbiAgICAgIG5ldyBFbXB0eUJ1Y2tldCh0aGlzLCAnRW1wdHlCdWNrZXQnLCB7XG4gICAgICAgIGJ1Y2tldDogdGhpcyxcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxufVxuIl19