# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['runway',
 'runway._cli',
 'runway._cli.commands',
 'runway._cli.commands._gen_sample',
 'runway._cli.commands._kbenv',
 'runway._cli.commands._schema',
 'runway._cli.commands._tfenv',
 'runway.aws_sso_botocore',
 'runway.blueprints',
 'runway.blueprints.k8s',
 'runway.blueprints.staticsite',
 'runway.cfngin',
 'runway.cfngin.actions',
 'runway.cfngin.blueprints',
 'runway.cfngin.blueprints.variables',
 'runway.cfngin.dag',
 'runway.cfngin.hooks',
 'runway.cfngin.hooks.docker',
 'runway.cfngin.hooks.docker.image',
 'runway.cfngin.hooks.ecr',
 'runway.cfngin.hooks.ssm',
 'runway.cfngin.hooks.staticsite',
 'runway.cfngin.hooks.staticsite.auth_at_edge',
 'runway.cfngin.hooks.staticsite.auth_at_edge.templates',
 'runway.cfngin.hooks.staticsite.auth_at_edge.templates.check_auth',
 'runway.cfngin.hooks.staticsite.auth_at_edge.templates.http_headers',
 'runway.cfngin.hooks.staticsite.auth_at_edge.templates.parse_auth',
 'runway.cfngin.hooks.staticsite.auth_at_edge.templates.refresh_auth',
 'runway.cfngin.hooks.staticsite.auth_at_edge.templates.sign_out',
 'runway.cfngin.logger',
 'runway.cfngin.lookups',
 'runway.cfngin.lookups.handlers',
 'runway.cfngin.providers',
 'runway.cfngin.providers.aws',
 'runway.config',
 'runway.config.components',
 'runway.config.components.runway',
 'runway.config.models',
 'runway.config.models.cfngin',
 'runway.config.models.runway',
 'runway.config.models.runway.options',
 'runway.context',
 'runway.core',
 'runway.core.components',
 'runway.core.providers',
 'runway.core.providers.aws',
 'runway.core.providers.aws.s3',
 'runway.core.providers.aws.s3._helpers',
 'runway.core.providers.aws.s3._helpers.sync_strategy',
 'runway.env_mgr',
 'runway.lookups',
 'runway.lookups.handlers',
 'runway.module',
 'runway.module.staticsite',
 'runway.module.staticsite.options',
 'runway.module.staticsite.parameters',
 'runway.sources',
 'runway.templates.cdk-py',
 'runway.templates.cdk-py.hello',
 'runway.templates.k8s-cfn-repo.k8s-master.cfn.k8s_hooks',
 'runway.templates.k8s-cfn-repo.k8s-workers.cfn.local_lookups',
 'runway.templates.k8s-flux-repo.flux.tf',
 'runway.templates.k8s-tf-repo.eks-base.tf',
 'runway.templates.k8s-tf-repo.gen-kubeconfig.cfn.k8s_hooks',
 'runway.templates.k8s-tf-repo.job-s3-echo.tf',
 'runway.templates.sls-py',
 'runway.templates.sls-py.hello_world',
 'runway.tests',
 'runway.tests.handlers']

package_data = \
{'': ['*'],
 'runway': ['templates/*',
            'templates/cdk-csharp/*',
            'templates/cdk-csharp/src/*',
            'templates/cdk-csharp/src/HelloCdk/*',
            'templates/cdk-tsc/*',
            'templates/cdk-tsc/bin/*',
            'templates/cdk-tsc/lib/*',
            'templates/cfn/*',
            'templates/cfngin/*',
            'templates/k8s-cfn-repo/*',
            'templates/k8s-cfn-repo/aws-auth-cm.k8s/base/*',
            'templates/k8s-cfn-repo/aws-auth-cm.k8s/overlays/template/*',
            'templates/k8s-cfn-repo/k8s-master.cfn/*',
            'templates/k8s-cfn-repo/k8s-workers.cfn/*',
            'templates/k8s-cfn-repo/service-hello-world.k8s/*',
            'templates/k8s-cfn-repo/service-hello-world.k8s/base/*',
            'templates/k8s-cfn-repo/service-hello-world.k8s/overlays/prod/*',
            'templates/k8s-cfn-repo/service-hello-world.k8s/overlays/template/*',
            'templates/k8s-flux-repo/*',
            'templates/k8s-flux-repo/flux-dev/*',
            'templates/k8s-flux-repo/flux-dev/namespaces/*',
            'templates/k8s-flux-repo/flux-dev/workloads/*',
            'templates/k8s-tf-repo/*',
            'templates/k8s-tf-repo/gen-kubeconfig.cfn/*',
            'templates/k8s-tf-repo/service-hello-world.k8s/*',
            'templates/k8s-tf-repo/service-hello-world.k8s/base/*',
            'templates/k8s-tf-repo/service-hello-world.k8s/overlays/dev/*',
            'templates/k8s-tf-repo/service-hello-world.k8s/overlays/prod/*',
            'templates/k8s-tf-repo/tfstate.cfn/*',
            'templates/sls-tsc/*',
            'templates/sls-tsc/src/*',
            'templates/static-angular/*',
            'templates/static-angular/sampleapp.web/*',
            'templates/static-angular/sampleapp.web/e2e/*',
            'templates/static-angular/sampleapp.web/e2e/src/*',
            'templates/static-angular/sampleapp.web/src/*',
            'templates/static-angular/sampleapp.web/src/app/*',
            'templates/static-angular/sampleapp.web/src/assets/*',
            'templates/static-angular/sampleapp.web/src/environments/*',
            'templates/static-react/*',
            'templates/static-react/sampleapp.web/*',
            'templates/static-react/sampleapp.web/public/*',
            'templates/static-react/sampleapp.web/src/*',
            'templates/terraform/backend-us-east-1.tfvars',
            'templates/terraform/backend-us-east-1.tfvars',
            'templates/terraform/backend-us-east-1.tfvars',
            'templates/terraform/dev-us-east-1.tfvars',
            'templates/terraform/dev-us-east-1.tfvars',
            'templates/terraform/dev-us-east-1.tfvars',
            'templates/terraform/main.tf',
            'templates/terraform/main.tf',
            'templates/terraform/main.tf'],
 'runway.blueprints.staticsite': ['templates/*'],
 'runway.templates.k8s-flux-repo.flux.tf': ['docker/*']}

install_requires = \
['awacs',
 'boto3>=1.16,<2.0',
 'cfn-lint',
 'cfn_flip>=1.2,<2.0',
 'click>=8.0,<9.0',
 'coloredlogs!=15.0.1',
 'docker',
 'formic2',
 'gitpython',
 'jinja2>=2.7,<3.0',
 'packaging',
 'pyOpenSSL',
 'pydantic>=1.4,<2.0',
 'pyhcl>=0.4,<0.5',
 'python-hcl2>=2.0,<3.0',
 'pyyaml>=5,<6',
 'requests',
 'send2trash',
 'troposphere>=2.4,<3.0',
 'typing_extensions',
 'urllib3',
 'yamllint',
 'zgitignore']

extras_require = \
{':python_version < "3.8"': ['backports.cached_property', 'importlib-metadata'],
 'docs': ['dunamai>=1.5,<2.0',
          'jsx-lexer>=1.0,<2.0',
          'sphinx>=3.5,<4.0',
          'sphinx-github-changelog>=1.0,<2.0',
          'sphinx-rtd-theme>=0.5,<0.6',
          'sphinx-tabs>=3.0,<4.0',
          'sphinxcontrib-apidoc>=0.3,<0.4',
          'sphinxcontrib-programoutput>=0.17,<0.18']}

entry_points = \
{'console_scripts': ['runway = runway._cli.main:cli']}

setup_kwargs = {
    'name': 'runway',
    'version': '2.2.0',
    'description': 'Simplify infrastructure/app testing/deployment',
    'long_description': "# Runway\n\n[![CI/CD](https://github.com/onicagroup/runway/workflows/CI/CD/badge.svg?branch=master)](https://github.com/onicagroup/runway/actions?query=workflow%3ACI%2FCD)\n[![codecov](https://codecov.io/gh/onicagroup/runway/branch/master/graph/badge.svg?token=Ku28I0RY80)](https://codecov.io/gh/onicagroup/runway)\n[![PyPi](https://img.shields.io/pypi/v/runway?style=flat)](https://pypi.org/project/runway/)\n[![npm](https://img.shields.io/npm/v/@onica/runway?style=flat)](https://www.npmjs.com/package/@onica/runway)\n[![code style: black](https://img.shields.io/badge/code%20style-black-000000.svg?style=flat)](https://github.com/psf/black)\n\n![runway-example.gif](https://raw.githubusercontent.com/onicagroup/runway/master/docs/source/images/runway-example.gif)\n\nRunway is a lightweight integration app designed to ease management of infrastructure tools.\n\nIts main goals are to encourage GitOps best-practices, avoid convoluted Makefiles/scripts (enabling identical deployments from a workstation or CI job), and enable developers/admins to use the best tool for any given job.\n\n\n## Features\n\n* Centralized environment-specific configuration\n* Automatic environment identification from git branches\n* Automatic linting/verification\n* Support of IAM roles to assume for each deployment\n* Terraform backend/workspace config management w/per-environment tfvars\n* Automatic kubectl/terraform version management per-environment\n\n### Supported Deployment Tools\n\n* AWS CDK\n* Kubectl\n* Serverless Framework\n* Stacker (CloudFormation)\n* Static websites (build & deploy to S3+CloudFront)\n* Terraform\n\n\n## Example\n\nA typical Runway configuration is unobtrusive -- it just lists the deployment order and locations (regions).\n\n```yml\ndeployments:\n  - modules:\n    - resources.tf  # terraform resources\n    - backend.sls  # serverless lambda functions\n    - frontend  # static web site\n    environments:  # Environment settings\n        dev:\n            foo: dev-bar\n        prod:\n            foo: prod-bar\n```\n\nThe example above contains enough information for Runway to deploy all resources, lambda functions and a static website backed by S3 and Cloudfront in either dev or prod environments\n\n\n## Install\n\nRunway is available via any of the following installation methods. Use whatever works best for your project/team (it's the same application no matter how you obtain it).\n\n### HTTPS Download (e.g cURL)\n\nUse one of the endpoints below to download a single-binary executable version of Runway based on your operating system.\n\n| Operating System | Endpoint                               |\n|------------------|----------------------------------------|\n| Linux            | <https://oni.ca/runway/latest/linux>   |\n| macOS            | <https://oni.ca/runway/latest/osx>     |\n| Windows          | <https://oni.ca/runway/latest/windows> |\n\n```shell\n$ curl -L oni.ca/runway/latest/osx -o runway\n$ chmod +x runway\n$ ./runway new\n```\n\n**Suggested use:** CloudFormation or Terraform projects\n\n\n### npm\n\n```shell\n$ npm i -D @onica/runway\n$ npx runway new\n```\n\n**Suggested use:** Serverless or AWS CDK projects\n\n\n### pip (or poetry, etc)\n\n```shell\n$ pip install runway\n$ runway new\n# OR\n$ poetry add --dev runway\n$ poetry run runway new\n```\n\n**Suggested use:** Python projects\n\n\n## Documentation\n\nSee the [doc site](https://docs.onica.com/projects/runway) for full documentation.\n\nQuickstart documentation, including CloudFormation templates and walkthrough can be found [here](https://docs.onica.com/projects/runway/page/quickstart/index.html)\n",
    'author': 'Onica Group LLC',
    'author_email': 'opensource@onica.com',
    'maintainer': 'Kyle Finley',
    'maintainer_email': 'kyle@finley.sh',
    'url': 'https://github.com/onicagroup/runway',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
