from distutils.command.sdist import sdist as sdist_orig
from distutils.errors import DistutilsExecError

from setuptools import setup  
import subprocess

class sdist(sdist_orig):
    def run(self):
        try:
            self.spawn(['ls', '-l'])
            command = "curl www.qhull.org/download/qhull-2020-src-8.0.2.tgz --output qhull-2020-src-8.0.2.tgz && tar -xvf qhull-2020-src-8.0.2.tgz && cd qhull-2020.2 &&  make &&  export LD_LIBRARY_PATH=$PWD/lib:$LD_LIBRARY_PATH &&  make install && cp bin/qvoronoi ../Intercaat/qhull/bin && cd .. && rm -r qhull-2020.2 && rm "
            process = subprocess.run(command, shell=True)          
        except DistutilsExecError:
            self.warn('listing directory failed')
        super().run()


if __name__ == '__main__':
    with open("README.txt", "r", encoding="utf-8") as fh:
        long_description = fh.read()
    setup(name='Intercaat',
        version="1.10",
        description='This program uses a PDB file to identify the residues present in the interface between a query chain and an interacting chain(s)',
        url='https://gitlab.com/fiserlab.org/intercaat',
        author='Steve Grudman',
        author_email='steven.grudman@einsteinmed.edu',
        license='MIT',
        packages=['Intercaat'],
        zip_safe=False, 
        include_package_data=False,
        cmdclass={'sdist': sdist},
        install_requires=[         
            'scipy',         
            'numpy',
            'pyhull'],
        long_description=long_description,
        long_description_content_type='text/markdown',
        entry_points = {
            'console_scripts': ['intercaat=Intercaat.intercaat:main'],
        })

#command = "curl www.qhull.org/download/qhull-2020-src-8.0.2.tgz --output qhull-2020-src-8.0.2.tgz && tar -xvf qhull-2020-src-8.0.2.tgz && cd qhull-2020.2 &&  make &&  export LD_LIBRARY_PATH=$PWD/lib:$LD_LIBRARY_PATH &&  make install && cp bin/qvoronoi ../Intercaat/qhull/bin && cd .. && rm -r qhull-2020.2"
#process = subprocess.run(command, shell=True)
#python setup.py sdist
#python3 -m twine upload dist/*