# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['voice_presentation_control']

package_data = \
{'': ['*'],
 'voice_presentation_control': ['vosk_models/vosk-model-small-en-us-0.15/*',
                                'vosk_models/vosk-model-small-en-us-0.15/am/*',
                                'vosk_models/vosk-model-small-en-us-0.15/conf/*',
                                'vosk_models/vosk-model-small-en-us-0.15/graph/*',
                                'vosk_models/vosk-model-small-en-us-0.15/graph/phones/*',
                                'vosk_models/vosk-model-small-en-us-0.15/ivector/*']}

install_requires = \
['PyAudio>=0.2.11,<0.3.0',
 'PyAutoGUI>=0.9.53,<0.10.0',
 'numpy>=1.22.3,<2.0.0',
 'typer>=0.4.1,<0.5.0',
 'vosk==0.3.32']

entry_points = \
{'console_scripts': ['vpc = voice_presentation_control.cli:start_cli']}

setup_kwargs = {
    'name': 'voice-presentation-control',
    'version': '0.2.0',
    'description': "voice-presentation-control is a tool that allows you to control your presentation using voice when you don't have a presentation pen or when it's inconvinient to use the keyboard.",
    'long_description': '<div id="top"></div>\n\n<!-- PROJECT SHIELDS -->\n\n[<div align="center"> ![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![MIT License][license-shield]][license-url]\n[![Issues][issues-shield]][issues-url]\n[![Issues Closed][issues-closed-shield]</div>][issues-closed-url]\n\n<br />\n\n<!-- PROJECT LOGO -->\n\n![voice-presentation-control](https://socialify.git.ci/wst24365888/voice-presentation-control/image?description=1&font=KoHo&name=1&owner=1&pattern=Circuit%20Board&theme=Light)\n\n<br />\n<div align="center">\n<p align="center">\n    <a href="https://github.com/wst24365888/voice-presentation-control#usage"><strong>Explore Usage »</strong></a>\n    <br />\n    <br />\n    <a href="https://github.com/wst24365888/voice-presentation-control/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/wst24365888/voice-presentation-control/issues">Request Feature</a>\n  </p>\n</div>\n\n<!-- TABLE OF CONTENTS -->\n\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#installation">Installation</a></li>\n        <li><a href="#usages">Usages</a></li>\n      </ul>\n    </li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n  </ol>\n</details>\n\n<!-- ABOUT THE PROJECT -->\n\n## About The Project\n\n`voice-presentation-control` is a tool that allows you to control your presentation using voice when you don\'t have a presentation pen or when it\'s inconvinient to use the keyboard.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- GETTING STARTED -->\n\n## Getting Started\n\n### Installation\n\n#### Using `pip`\n\n`pip install voice-presentation-control`\n\n#### Using `.whl`\n\nSee [releases](https://github.com/wst24365888/voice-presentation-control/releases).\n\n### Usages\n\n#### Usage of `vpc`\n\n`vpc [OPTIONS] COMMAND`\n\n##### Options\n\n| Option          | Description                                          |\n| --------------- | ---------------------------------------------------- |\n| `-v, --verbose` | Show the detailed log of voice-presentation-control. |\n| `--version`     | Show the version of voice-presentation-control.      |\n| `--help`        | Show help and exit.                                  |\n\n##### Commands\n\n| Command | Description                                  |\n| ------- | -------------------------------------------- |\n| `mic`   | Check the settings for the microphone input. |\n| `start` | Start vpc.                                   |\n\n#### Usage of `vpc mic`\n\n`vpc mic [OPTIONS] COMMAND`\n\n##### Options\n\n| Option   | Description         |\n| -------- | ------------------- |\n| `--help` | Show help and exit. |\n\n##### Commands\n\n| Command | Description                                                                                         |\n| ------- | --------------------------------------------------------------------------------------------------- |\n| `list`  | List all audio input devices. You can check the device index you want to use by using this command. |\n| `test`  | Test audio environment. Talk and determine the threshold by using this command.                     |\n\n#### Usage of `vpc mic test`\n\n`vpc mic test [OPTIONS]`\n\n##### Options\n\n| Option                     | Description                                                                |\n| -------------------------- | -------------------------------------------------------------------------- |\n| `-i, --input-device-index` | Set input device index. Check your devices by `vpc mic list`. [default: 1] |\n| `--help`                   | Show help and exit.                                                        |\n\n#### Usage of `vpc start`\n\n`vpc start [OPTIONS]`\n\n##### Options\n\n| Option                     | Description                                                                |\n| -------------------------- | -------------------------------------------------------------------------- |\n| `-i, --input-device-index` | Set input device index. Check your devices by `vpc mic list`. [default: 1] |\n| `-t, --threshold`          | Set threshold. Test your environment by `vpc mic test`.  [default: 3000]   |\n| `--help`                   | Show help and exit.                                                        |\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- ROADMAP -->\n\n## Roadmap\n\n- [ ] Add more tests.\n\nSee the [open issues](https://github.com/wst24365888/voice-presentation-control/issues)\nfor a full list of proposed features (and known issues).\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- CONTRIBUTING -->\n\n## Contributing\n\nContributions are what make the open source community such an amazing place to\nlearn, inspire, and create. Any contributions you make are **greatly\nappreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and\ncreate a pull request. You can also simply open an issue with the tag\n"enhancement". Don\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feat/amazing-feature`)\n3. Commit your Changes with\n   [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/)\n4. Push to the Branch (`git push origin feat/amazing-feature`)\n5. Open a Pull Request\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- LICENSE -->\n\n## License\n\nDistributed under the MIT License. See\n[LICENSE](https://github.com/wst24365888/voice-presentation-control/blob/main/LICENSE)\nfor more information.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n<!-- CONTACT -->\n\n## Contact\n\n### Author\n\n- HSING-HAN, WU (Xyphuz)\n  - Mail me: xyphuzwu@gmail.com\n  - About me: <https://about.xyphuz.com>\n  - GitHub: <https://github.com/wst24365888>\n\n### Project Link\n\n- <https://github.com/wst24365888/voice-presentation-control>\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n[contributors-shield]: https://img.shields.io/github/contributors/wst24365888/voice-presentation-control.svg?style=for-the-badge\n[contributors-url]: https://github.com/wst24365888/voice-presentation-control/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/wst24365888/voice-presentation-control.svg?style=for-the-badge\n[forks-url]: https://github.com/wst24365888/voice-presentation-control/network/members\n[stars-shield]: https://img.shields.io/github/stars/wst24365888/voice-presentation-control.svg?style=for-the-badge\n[stars-url]: https://github.com/wst24365888/voice-presentation-control/stargazers\n[issues-shield]: https://img.shields.io/github/issues/wst24365888/voice-presentation-control.svg?style=for-the-badge\n[issues-url]: https://github.com/wst24365888/voice-presentation-control/issues\n[issues-closed-shield]: https://img.shields.io/github/issues-closed/wst24365888/voice-presentation-control.svg?style=for-the-badge\n[issues-closed-url]: https://github.com/wst24365888/voice-presentation-control/issues?q=is%3Aissue+is%3Aclosed\n[license-shield]: https://img.shields.io/github/license/wst24365888/voice-presentation-control.svg?style=for-the-badge\n[license-url]: https://github.com/wst24365888/voice-presentation-control/blob/main/LICENSE',
    'author': 'Xyphuz',
    'author_email': 'xyphuzwu@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/wst24365888/voice-presentation-control',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
