import logging
from logging import config

LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default_formatter': {
            'format': '%(asctime)s:[%(levelname)s] %(message)s',
        },
    },
    'handlers': {
        'stream_handler': {
            'class': 'logging.StreamHandler',
            'formatter': 'default_formatter',
        },
    },
    'loggers': {
        'root': {
            'handlers': ['stream_handler'],
            'level': 'DEBUG',
            'propagate': True,
        },
    },
}

config.dictConfig(LOGGING_CONFIG)

LOGGER = logging.getLogger('root')
