import json

from django.db import models

from vas_core.app.models import BaseModelAbstract


class BillerField(BaseModelAbstract, models.Model):
    biller = models.OneToOneField("Biller", on_delete=models.CASCADE)
    valiation_field = models.TextField(blank=True)
    klass = models.URLField(null=True, blank=True)
    requery_url = models.URLField(null=True, blank=True)
    fields_json = models.JSONField(null=False, blank=False)

    def to_redis(self):
        data = {
            "valiation_field": self.valiation_field,
            "klass": self.klass,
            "requery_url": self.requery_url,
            "fields_json": self.fields_json,
        }
        return json.dumps(data)
