# Generated by Django 4.1.1 on 2022-09-10 21:40

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import vas_core.app.models.base


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('app', '0002_category_country_alter_category_description'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccountConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deletedViaCascade', models.BooleanField(default=False, editable=False)),
                ('old_id', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletedById', models.UUIDField(blank=True, null=True)),
                ('deletedAt', models.DateTimeField(blank=True, db_column='deletedAt', null=True)),
                ('createdAt', models.DateTimeField(auto_now_add=True, db_column='createdAt')),
                ('updatedAt', models.DateTimeField(auto_now=True, db_column='updatedAt')),
                ('account', models.CharField(max_length=100)),
                ('description', models.CharField(max_length=100)),
                ('is_dynamic', models.BooleanField(default=False)),
                ('createdBy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-createdAt',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AccountingEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deletedViaCascade', models.BooleanField(default=False, editable=False)),
                ('old_id', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletedById', models.UUIDField(blank=True, null=True)),
                ('deletedAt', models.DateTimeField(blank=True, db_column='deletedAt', null=True)),
                ('createdAt', models.DateTimeField(auto_now_add=True, db_column='createdAt')),
                ('updatedAt', models.DateTimeField(auto_now=True, db_column='updatedAt')),
                ('createdBy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-createdAt',),
                'abstract': False,
            },
        ),
        migrations.AlterModelOptions(
            name='category',
            options={'ordering': ('description',)},
        ),
        migrations.AddField(
            model_name='category',
            name='old_id',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='country',
            name='old_id',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='category',
            name='description',
            field=vas_core.app.models.base.LocalizationField(),
        ),
        migrations.AlterField(
            model_name='country',
            name='code',
            field=models.CharField(max_length=3, unique=True),
        ),
        migrations.CreateModel(
            name='Provider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deletedViaCascade', models.BooleanField(default=False, editable=False)),
                ('old_id', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletedById', models.UUIDField(blank=True, null=True)),
                ('deletedAt', models.DateTimeField(blank=True, db_column='deletedAt', null=True)),
                ('createdAt', models.DateTimeField(auto_now_add=True, db_column='createdAt')),
                ('updatedAt', models.DateTimeField(auto_now=True, db_column='updatedAt')),
                ('name', vas_core.app.models.base.LocalizationField()),
                ('code', models.CharField(max_length=30, unique=True)),
                ('api_url', models.URLField(blank=True, null=True)),
                ('api_type', models.CharField(choices=[('XML', 'XML'), ('JSON', 'JSON')], max_length=10)),
                ('auth_username', models.CharField(blank=True, max_length=255, null=True)),
                ('auth_password', models.CharField(blank=True, max_length=255, null=True)),
                ('auth_token', models.CharField(blank=True, max_length=255, null=True)),
                ('notify', models.BooleanField(default=True)),
                ('accounting_entry', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.accountingentry')),
                ('createdBy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-createdAt',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FeeAccountConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deletedViaCascade', models.BooleanField(default=False, editable=False)),
                ('old_id', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletedById', models.UUIDField(blank=True, null=True)),
                ('deletedAt', models.DateTimeField(blank=True, db_column='deletedAt', null=True)),
                ('createdAt', models.DateTimeField(auto_now_add=True, db_column='createdAt')),
                ('updatedAt', models.DateTimeField(auto_now=True, db_column='updatedAt')),
                ('amount', models.DecimalField(decimal_places=5, max_digits=50)),
                ('is_percentage', models.BooleanField(default=False)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.accountconfig')),
                ('createdBy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-createdAt',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Channel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deletedViaCascade', models.BooleanField(default=False, editable=False)),
                ('old_id', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletedById', models.UUIDField(blank=True, null=True)),
                ('deletedAt', models.DateTimeField(blank=True, db_column='deletedAt', null=True)),
                ('createdAt', models.DateTimeField(auto_now_add=True, db_column='createdAt')),
                ('updatedAt', models.DateTimeField(auto_now=True, db_column='updatedAt')),
                ('code', models.CharField(max_length=30, unique=True)),
                ('description', models.CharField(max_length=255)),
                ('shortcode', models.CharField(max_length=30, unique=True)),
                ('is_active', models.BooleanField(default=True)),
                ('createdBy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-createdAt',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Biller',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deletedViaCascade', models.BooleanField(default=False, editable=False)),
                ('old_id', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('deletedById', models.UUIDField(blank=True, null=True)),
                ('deletedAt', models.DateTimeField(blank=True, db_column='deletedAt', null=True)),
                ('createdAt', models.DateTimeField(auto_now_add=True, db_column='createdAt')),
                ('updatedAt', models.DateTimeField(auto_now=True, db_column='updatedAt')),
                ('biller_id', models.CharField(max_length=255, unique=True)),
                ('name', vas_core.app.models.base.LocalizationField()),
                ('description', vas_core.app.models.base.LocalizationField()),
                ('display_sequence', models.IntegerField(default=1)),
                ('narration_format', models.TextField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('accounting_entry', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.accountingentry')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.category')),
                ('country', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.country')),
                ('createdBy', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('provider', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.provider')),
            ],
            options={
                'ordering': ('-display_sequence',),
            },
        ),
        migrations.AddField(
            model_name='accountingentry',
            name='fees',
            field=models.ManyToManyField(blank=True, null=True, to='app.feeaccountconfig'),
        ),
        migrations.AddField(
            model_name='accountingentry',
            name='settlement_account',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app.accountconfig'),
        ),
    ]
