# KerasNLP: Modular NLP Workflows for Keras
[![](https://github.com/keras-team/keras-nlp/workflows/Tests/badge.svg?branch=master)](https://github.com/keras-team/keras-nlp/actions?query=workflow%3ATests+branch%3Amaster)
![Python](https://img.shields.io/badge/python-v3.8.0+-success.svg)
![Tensorflow](https://img.shields.io/badge/tensorflow-v2.5.0+-success.svg)
[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](https://github.com/keras-team/keras-nlp/issues)


KerasNLP is a natural language processing library that supports users through
their entire development cycle. Our workflows are built from modular components 
that have state-of-the-art preset weights and architectures when used 
out-of-the-box and are easily customizable when more control is needed. We 
emphasize in-graph computation for all workflows so that developers can expect 
easy productionization using the TensorFlow ecosystem.

This library is an extension of the core Keras API; all high-level modules are 
[`Layers`](https://keras.io/api/layers/) or 
[`Models`](https://keras.io/api/models/) that recieve that same level of polish 
as core Keras. If you are familiar with Keras, congratulations! You already 
understand most of KerasNLP.

See our [Getting Started guide](https://keras.io/guides/keras_nlp/getting_started) 
for example usage of our modular API starting with evaluating pretrained models 
and building up to designing a novel transformer architecture and training a 
tokenizer from scratch.  

We are a new and growing project and welcome [contributions](CONTRIBUTING.md).

## Quick Links

### For everyone

- [Home Page](https://keras.io/keras_nlp)
- [Developer Guides](https://keras.io/guides/keras_nlp)
- [API Reference](https://keras.io/api/keras_nlp)
- [Getting Started guide](https://keras.io/guides/keras_nlp/getting_started) 

### For contributors

- [Contributing Guide](CONTRIBUTING.md)
- [Roadmap](ROADMAP.md)
- [Style Guide](STYLE_GUIDE.md)
- [API Design Guide](API_DESIGN_GUIDE.md)
- [Call for Contributions](https://github.com/keras-team/keras-nlp/issues?q=is%3Aissue+is%3Aopen+label%3A%22contributions+welcome%22)

## Installation

To install the latest official release:

```
pip install keras-nlp tensorflow --upgrade
```

To install the latest unreleased changes to the library, we recommend using
pip to install directly from the master branch on github:

```
pip install git+https://github.com/keras-team/keras-nlp.git tensorflow --upgrade
```

## Quickstart

Fine-tune BERT on a small sentiment analysis task using the 
[`keras_nlp.models`](https://keras.io/api/keras_nlp/models/) API:

```python
import keras_nlp
from tensorflow import keras
import tensorflow_datasets as tfds

imdb_train, imdb_test = tfds.load(
    "imdb_reviews",
    split=["train", "test"],
    as_supervised=True,
    batch_size=16,
)
classifier = keras_nlp.models.BertClassifier.from_preset(
    "bert_base_en_uncased",
)
classifier.compile(
    loss=keras.losses.SparseCategoricalCrossentropy(from_logits=True),
    optimizer=keras.optimizers.Adam(5e-5),
    metrics=keras.metrics.SparseCategoricalAccuracy(),
    jit_compile=True,
)
classifier.fit(
    imdb_train,
    validation_data=imdb_test,
    epochs=1,
)

# Predict a new example
classifier.predict(["What an amazing movie, three hours of pure bliss!"])
```

For more in depth guides and examples, visit https://keras.io/keras_nlp/.

## Compatibility

We follow [Semantic Versioning](https://semver.org/), and plan to
provide backwards compatibility guarantees both for code and saved models built
with our components. While we continue with pre-release `0.y.z` development, we
may break compatibility at any time and APIs should not be consider stable.

## Disclaimer

KerasNLP provides access to pre-trained models via the `keras_nlp.models` API.
These pre-trained models are provided on an "as is" basis, without warranties
or conditions of any kind. The following underlying models are provided by third
parties, and subject to separate licenses:
DistilBERT, RoBERTa, XLM-RoBERTa, DeBERTa, and GPT-2.

## Citing KerasNLP

If KerasNLP helps your research, we appreciate your citations.
Here is the BibTeX entry:

```bibtex
@misc{kerasnlp2022,
  title={KerasNLP},
  author={Watson, Matthew, and Qian, Chen, and Bischof, Jonathan and Chollet, 
  Fran\c{c}ois and others},
  year={2022},
  howpublished={\url{https://github.com/keras-team/keras-nlp}},
}
```

## Acknowledgements

Thank you to all of our wonderful contributors!

<a href="https://github.com/keras-team/keras-nlp/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=keras-team/keras-nlp" />
</a>
