# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AudioConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'encoding': 'str',
        'sample_rate': 'float',
        'sample_size': 'float',
        'payload_type': 'float'
    }

    attribute_map = {
        'encoding': 'encoding',
        'sample_rate': 'sampleRate',
        'sample_size': 'sampleSize',
        'payload_type': 'payloadType'
    }

    def __init__(self, encoding=None, sample_rate=None, sample_size=None, payload_type=None):  # noqa: E501
        """AudioConfig - a model defined in Swagger"""  # noqa: E501
        self._encoding = None
        self._sample_rate = None
        self._sample_size = None
        self._payload_type = None
        self.discriminator = None
        if encoding is not None:
            self.encoding = encoding
        if sample_rate is not None:
            self.sample_rate = sample_rate
        if sample_size is not None:
            self.sample_size = sample_size
        if payload_type is not None:
            self.payload_type = payload_type

    @property
    def encoding(self):
        """Gets the encoding of this AudioConfig.  # noqa: E501

        The encoding scheme to be used  # noqa: E501

        :return: The encoding of this AudioConfig.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this AudioConfig.

        The encoding scheme to be used  # noqa: E501

        :param encoding: The encoding of this AudioConfig.  # noqa: E501
        :type: str
        """

        self._encoding = encoding

    @property
    def sample_rate(self):
        """Gets the sample_rate of this AudioConfig.  # noqa: E501

        Sampling rate for audio stream  # noqa: E501

        :return: The sample_rate of this AudioConfig.  # noqa: E501
        :rtype: float
        """
        return self._sample_rate

    @sample_rate.setter
    def sample_rate(self, sample_rate):
        """Sets the sample_rate of this AudioConfig.

        Sampling rate for audio stream  # noqa: E501

        :param sample_rate: The sample_rate of this AudioConfig.  # noqa: E501
        :type: float
        """

        self._sample_rate = sample_rate

    @property
    def sample_size(self):
        """Gets the sample_size of this AudioConfig.  # noqa: E501

        Sample Size for the audio stream  # noqa: E501

        :return: The sample_size of this AudioConfig.  # noqa: E501
        :rtype: float
        """
        return self._sample_size

    @sample_size.setter
    def sample_size(self, sample_size):
        """Sets the sample_size of this AudioConfig.

        Sample Size for the audio stream  # noqa: E501

        :param sample_size: The sample_size of this AudioConfig.  # noqa: E501
        :type: float
        """

        self._sample_size = sample_size

    @property
    def payload_type(self):
        """Gets the payload_type of this AudioConfig.  # noqa: E501

        Payload Type for the given codec  # noqa: E501

        :return: The payload_type of this AudioConfig.  # noqa: E501
        :rtype: float
        """
        return self._payload_type

    @payload_type.setter
    def payload_type(self, payload_type):
        """Sets the payload_type of this AudioConfig.

        Payload Type for the given codec  # noqa: E501

        :param payload_type: The payload_type of this AudioConfig.  # noqa: E501
        :type: float
        """

        self._payload_type = payload_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AudioConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AudioConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
