
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/kinematics/SwerveDriveKinematics.h>





namespace rpygen {

using namespace frc;


template <size_t NumModules>
struct bind_frc__SwerveDriveKinematics {

    

    py::class_<typename frc::SwerveDriveKinematics<NumModules>> cls_SwerveDriveKinematics;




    py::module &m;
    std::string clsName;

bind_frc__SwerveDriveKinematics(py::module &m, const char * clsName) :
    cls_SwerveDriveKinematics(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_SwerveDriveKinematics.doc() =
    "Helper class that converts a chassis velocity (dx, dy, and dtheta components)\n"
"into individual module states (speed and angle).\n"
"\n"
"The inverse kinematics (converting from a desired chassis velocity to\n"
"individual module states) uses the relative locations of the modules with\n"
"respect to the center of rotation. The center of rotation for inverse\n"
"kinematics is also variable. This means that you can set your set your center\n"
"of rotation in a corner of the robot to perform special evasion maneuvers.\n"
"\n"
"Forward kinematics (converting an array of module states into the overall\n"
"chassis motion) is performs the exact opposite of what inverse kinematics\n"
"does. Since this is an overdetermined system (more equations than variables),\n"
"we use a least-squares approximation.\n"
"\n"
"The inverse kinematics: [moduleStates] = [moduleLocations] * [chassisSpeeds]\n"
"We take the Moore-Penrose pseudoinverse of [moduleLocations] and then\n"
"multiply by [moduleStates] to get our chassis speeds.\n"
"\n"
"Forward kinematics is also used for odometry -- determining the position of\n"
"the robot on the field using encoders and a gyro.";

  cls_SwerveDriveKinematics
      .def("toSwerveModuleStates", &frc::SwerveDriveKinematics<NumModules>::ToSwerveModuleStates,
      py::arg("chassisSpeeds"), py::arg("centerOfRotation")=Translation2d ( ), release_gil(), py::doc(
    "Performs inverse kinematics to return the module states from a desired\n"
"chassis velocity. This method is often used to convert joystick values into\n"
"module speeds and angles.\n"
"\n"
"This function also supports variable centers of rotation. During normal\n"
"operations, the center of rotation is usually the same as the physical\n"
"center of the robot; therefore, the argument is defaulted to that use case.\n"
"However, if you wish to change the center of rotation for evasive\n"
"maneuvers, vision alignment, or for any other use case, you can do so.\n"
"\n"
":param chassisSpeeds:    The desired chassis speed.\n"
":param centerOfRotation: The center of rotation. For example, if you set the\n"
" center of rotation at one corner of the robot and provide a chassis speed\n"
" that only has a dtheta component, the robot will rotate around that corner.\n"
"\n"
":returns: An array containing the module states. Use caution because these\n"
"          module states are not normalized. Sometimes, a user input may cause one of\n"
"          the module speeds to go above the attainable max velocity. Use the\n"
"          :meth:`desaturateWheelSpeeds` function to rectify this issue.\n"
"          In addition, you can use Python unpacking syntax\n"
"          to directly assign the module states to variables::\n"
"\n"
"            fl, fr, bl, br = kinematics.toSwerveModuleStates(chassisSpeeds)\n")
  )
    
      .def("toChassisSpeeds", static_cast<ChassisSpeeds (frc::SwerveDriveKinematics<NumModules>::*)(wpi::array<SwerveModuleState, NumModules >) const>(
&frc::SwerveDriveKinematics<NumModules>::ToChassisSpeeds),
      py::arg("moduleStates"), release_gil(), py::doc(
    "Performs forward kinematics to return the resulting chassis state from the\n"
"given module states. This method is often used for odometry -- determining\n"
"the robot's position on the field using data from the real-world speed and\n"
"angle of each module on the robot.\n"
"\n"
":param moduleStates: The state of the modules as an wpi::array of type\n"
"                     SwerveModuleState, NumModules long as measured from respective encoders\n"
"                     and gyros. The order of the swerve module states should be same as passed\n"
"                     into the constructor of this class.\n"
"\n"
":returns: The resulting chassis speed.")
  )
    
      .def_static("desaturateWheelSpeeds", [](wpi::array<SwerveModuleState, NumModules> moduleStates, units::meters_per_second_t attainableMaxSpeed) {
  frc::SwerveDriveKinematics<NumModules>::DesaturateWheelSpeeds(&moduleStates, attainableMaxSpeed);
  return moduleStates;
}
,
      py::arg("moduleStates"), py::arg("attainableMaxSpeed"), py::doc(
    "Renormalizes the wheel speeds if any individual speed is above the\n"
"specified maximum.\n"
"\n"
"Sometimes, after inverse kinematics, the requested speed\n"
"from one or more modules may be above the max attainable speed for the\n"
"driving motor on that module. To fix this issue, one can reduce all the\n"
"wheel speeds to make sure that all requested module speeds are at-or-below\n"
"the absolute threshold, while maintaining the ratio of speeds between\n"
"modules.\n"
"\n"
":param moduleStates:       Reference to array of module states. The array will be\n"
"                           mutated with the normalized speeds!\n"
":param attainableMaxSpeed: The absolute max speed that a module can reach.")
  )
    
;

  

    if (set_doc) {
        cls_SwerveDriveKinematics.doc() = set_doc;
    }
    if (add_doc) {
        cls_SwerveDriveKinematics.doc() = py::cast<std::string>(cls_SwerveDriveKinematics.doc()) + add_doc;
    }

    if constexpr (NumModules == 2) {
  cls_SwerveDriveKinematics.def(py::init<Translation2d, Translation2d>());
} else if constexpr (NumModules == 3) {
  cls_SwerveDriveKinematics.def(py::init<Translation2d, Translation2d, Translation2d>());
} else if constexpr (NumModules == 4) {
  cls_SwerveDriveKinematics.def(py::init<Translation2d, Translation2d, Translation2d, Translation2d>());
} else if constexpr (NumModules == 6) {
  cls_SwerveDriveKinematics.def(py::init<Translation2d, Translation2d, Translation2d, Translation2d, Translation2d, Translation2d>());
}

}

}; // struct bind_frc__SwerveDriveKinematics

}; // namespace rpygen