#pragma once

#include "ctre/phoenix/ErrorCode.h"

/* forward proto's */
namespace ctre {
	namespace phoenix {
		namespace motorcontrol {
			namespace can {
				class BaseMotorController;
			}
		}
	}
}

namespace ctre {
	namespace phoenix {
		namespace motorcontrol {

			/**
			  * Collection of simulation commands available to a VictorSPX motor controller.
			  *
			  * Use the getSimCollection() routine inside your motor controller to create the respective sim collection.
			  */
			class VictorSPXSimCollection {
			public:
				/**
				 * Constructor for VictorSPXSimCollection
				 * @param motorController VictorSPX Motor Controller to connect Collection to
				 */
				VictorSPXSimCollection(ctre::phoenix::motorcontrol::can::BaseMotorController& motorController);

				/**
				 * Gets the last error generated by this object. Not all functions return an
				 * error code but can potentially report errors. This function can be used
				 * to retrieve those error codes.
				 *
				 * @return Last Error Code generated by a function.
				 */
				ErrorCode GetLastError();
				
				/**
				 * Gets the simulated output voltage across M+ and M- for the motor.
				 * 
				 * @return applied voltage to the motor in volts
				 */
				double GetMotorOutputLeadVoltage();

				/**
				 * Sets the simulated bus voltage of the VictorSPX.
				 * 
				 * The minimum allowed bus voltage is 4 V - values 
				 * below this will be promoted to 4 V.
				 * 
				 * @param vbat the bus voltage in volts
				 *
				 * @return  error code
				 */
				ErrorCode SetBusVoltage(double vbat);

			private:
				int _id;

			};

		} // namespace motorcontrol
	} // namespace phoenix
} // namespace ctre
