from setuptools import setup
import re
import logging
import sys

logging.basicConfig(stream=sys.stderr, level=logging.INFO)
log = logging.getLogger()

requirements = []
with open('requirements.txt') as f:
  requirements = f.read().splitlines()

version = ''
with open('discord/__init__.py') as f:
    version = re.search(r'^__version__\s*=\s*[\'"]([^\'"]*)[\'"]', f.read(), re.MULTILINE).group(1)

if not version:
    raise RuntimeError('version is not set')

if version.endswith(('a', 'b', 'rc')):
    # append version identifier based on commit count
    try:
        import subprocess
        p = subprocess.Popen(['git', 'rev-list', '--count', 'HEAD'],
                             stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        out, err = p.communicate()
        if out:
            version += out.decode('utf-8').strip()
        p = subprocess.Popen(['git', 'rev-parse', '--short', 'HEAD'],
                             stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        out, err = p.communicate()
        if out:
            version += '+g' + out.decode('utf-8').strip()
    except Exception:
        pass

readme = ''
with open('README.rst') as f:
    readme = f.read()

extras_require = {
    'voice': ['PyNaCl>=1.3.0,<1.5'],
    'docs': [
        'sphinx==3.0.3',
        'sphinxcontrib_trio==1.1.2',
        'sphinxcontrib-websupport',
    ]
}

log.warning("[WARNING] enhanced-dpy on PyPi uses 1.7!")
log.warning("To get the updates, install from git!")
log.warning("----------------------------------------")
log.warning("pip install -U git+https://github.com/iDevision/enhanced-discord.py")
log.warning("Support server: https://discord.gg/TvqYBrGXEm")

setup(name='enhanced-dpy',
      author='iDutchy',
      url='https://github.com/iDutchy/discord.py',
      project_urls={
        "Documentation": "https://enhanced-dpy.readthedocs.io/en/latest/",
        "Issue tracker": "https://github.com/iDutchy/discord.py/issues",
      },
      version=version,
      packages=['discord', 'discord.types', 'discord.ext.commands', 'discord.ext.tasks'],
      license='MIT',
      description='A Python wrapper for the Discord API',
      long_description=readme,
      long_description_content_type="text/x-rst",
      include_package_data=True,
      install_requires=requirements,
      extras_require=extras_require,
      python_requires='>=3.8.0',
      classifiers=[
        'Development Status :: 5 - Production/Stable',
        'License :: OSI Approved :: MIT License',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Topic :: Internet',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Utilities',
      ]
)
