/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.AbstractGangliaMessage;
import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import java.util.Arrays;
import java.util.Map;

public class GangliaMetadataMessage
extends AbstractGangliaMessage
implements IGangliaMetadataMessage {
    private final GangliaMessageTypeEnum metricType;
    private final String metricName2;
    private final String units;
    private final GangliaSlopeEnum slope;
    private final int tmax;
    private final int dmax;
    private final Map<String, String[]> extraValues;

    public GangliaMetadataMessage(String hostName, String metricName, boolean spoof, GangliaMessageTypeEnum metricType, String metricName2, String units, GangliaSlopeEnum slope, int tmax, int dmax, Map<String, String[]> extraValues) {
        super(GangliaMessageTypeEnum.METADATA, hostName, metricName, spoof);
        if (metricType == null) {
            throw new IllegalArgumentException();
        }
        if (metricName2 == null) {
            throw new IllegalArgumentException();
        }
        if (!metricName.equals(metricName2)) {
            throw new IllegalArgumentException();
        }
        if (units == null) {
            throw new IllegalArgumentException();
        }
        if (slope == null) {
            throw new IllegalArgumentException();
        }
        if (extraValues == null) {
            throw new IllegalArgumentException();
        }
        this.metricType = metricType;
        this.metricName2 = metricName2;
        this.units = units;
        this.slope = slope;
        this.tmax = tmax;
        this.dmax = dmax;
        this.extraValues = extraValues;
    }

    @Override
    public boolean isMetricValue() {
        return false;
    }

    @Override
    public boolean isMetricRequest() {
        return false;
    }

    @Override
    public boolean isMetricMetadata() {
        return true;
    }

    @Override
    public GangliaMessageTypeEnum getMetricType() {
        return this.metricType;
    }

    @Override
    public String getMetricName2() {
        return this.metricName2;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public GangliaSlopeEnum getSlope() {
        return this.slope;
    }

    @Override
    public int getTMax() {
        return this.tmax;
    }

    @Override
    public int getDMax() {
        return this.dmax;
    }

    @Override
    public Map<String, String[]> getExtraValues() {
        return this.extraValues;
    }

    @Override
    public String[] getGroups() {
        return this.extraValues.get("GROUP");
    }

    @Override
    public String getTitle() {
        return this.getFirstValue("TITLE");
    }

    @Override
    public String getDescription() {
        return this.getFirstValue("DESC");
    }

    @Override
    public String getFirstValue(String key) {
        String[] a = this.extraValues.get(key);
        if (a == null || a.length == 0) {
            return null;
        }
        return a[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getClass().getSimpleName());
        sb.append("{ recordType=");
        sb.append((Object)this.getRecordType());
        sb.append(", hostName=");
        sb.append(this.getHostName());
        sb.append(", metricName=");
        sb.append(this.getMetricName());
        sb.append(", spoof=");
        sb.append(this.isSpoof());
        sb.append(", metricType=");
        sb.append((Object)this.getMetricType());
        sb.append(", metricName2=");
        sb.append(this.getMetricName2());
        sb.append(", units=");
        sb.append(this.getUnits());
        sb.append(", slope=");
        sb.append((Object)this.getSlope());
        sb.append(", tmax=");
        sb.append(this.getTMax());
        sb.append(", dmax=");
        sb.append(this.getDMax());
        sb.append(", extraValues=");
        sb.append("{");
        if (!this.extraValues.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String[]> e : this.extraValues.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(e.getKey());
                sb.append("=");
                String[] v = e.getValue();
                if (v.length == 0) {
                    sb.append("[]");
                    continue;
                }
                if (v.length == 1) {
                    sb.append('\"');
                    sb.append(v[0]);
                    sb.append('\"');
                    continue;
                }
                sb.append("[");
                for (int i = 0; i < v.length; ++i) {
                    if (i > 1) {
                        sb.append(",");
                    }
                    sb.append('\"');
                    sb.append(v[i]);
                    sb.append('\"');
                }
                sb.append("]");
            }
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        IGangliaMetadataMessage t = (IGangliaMetadataMessage)o;
        if (!this.getRecordType().equals((Object)t.getRecordType())) {
            return false;
        }
        if (!this.getHostName().equals(t.getHostName())) {
            return false;
        }
        if (!this.getMetricName().equals(t.getMetricName())) {
            return false;
        }
        if (this.isSpoof() != t.isSpoof()) {
            return false;
        }
        if (!this.getMetricType().equals((Object)t.getMetricType())) {
            return false;
        }
        if (!this.getMetricName2().equals(t.getMetricName2())) {
            return false;
        }
        if (!this.getUnits().equals(t.getUnits())) {
            return false;
        }
        if (!this.getSlope().equals((Object)t.getSlope())) {
            return false;
        }
        if (this.getTMax() != t.getTMax()) {
            return false;
        }
        if (this.getDMax() != t.getDMax()) {
            return false;
        }
        Map<String, String[]> e1 = this.getExtraValues();
        Map<String, String[]> e2 = t.getExtraValues();
        if (e1.size() != e2.size()) {
            return false;
        }
        for (Map.Entry<String, String[]> e : e1.entrySet()) {
            Object[] val2;
            String key = e.getKey();
            Object[] val1 = e.getValue();
            if (Arrays.equals(val1, val2 = e2.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getMetricName().hashCode();
    }

    @Override
    public Object translateValue(Object value) {
        return value;
    }

    @Override
    public boolean isChanged(Object oldValue, Object newValue) {
        boolean changed = !oldValue.equals(newValue);
        return changed;
    }
}

