/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.vocabulary;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.datatypes.xsd.impl.RDFhtml;
import org.apache.jena.datatypes.xsd.impl.RDFjson;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class RDF {
    public static final String uri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final Resource Alt = Init.Alt();
    public static final Resource Bag = Init.Bag();
    public static final Resource Property = Init._Property();
    public static final Resource Seq = Init.Seq();
    public static final Resource Statement = Init.Statement();
    public static final Resource List = Init.List();
    public static final Resource nil = Init.nil();
    public static final Property first = Init.first();
    public static final Property rest = Init.rest();
    public static final Property subject = Init.subject();
    public static final Property predicate = Init.predicate();
    public static final Property object = Init.object();
    public static final Property type = Init.type();
    public static final Property value = Init.value();
    public static final Resource langString = Init.langString();
    public static final Resource HTML = Init.HTML();
    public static final Resource xmlLiteral = Init.xmlLiteral();
    public static final RDFDatatype dtRDFHTML = Init.dtRDFHTML();
    public static final RDFDatatype dtLangString = Init.dtLangString();
    public static final RDFDatatype dtXMLLiteral = Init.dtXMLLiteral();
    public static final RDFDatatype dtRDFJSON = Init.dtRDFJSON();
    public static final Resource JSON = Init.JSON();
    public static final Resource CompoundLiteral = Init.CompoundLiteral();
    public static final Property language = Init.language();
    public static final Property direction = Init.direction();

    public static String getURI() {
        return uri;
    }

    protected static final Resource resource(String local) {
        return ResourceFactory.createResource(uri + local);
    }

    protected static final Property property(String local) {
        return ResourceFactory.createProperty(uri, local);
    }

    public static Property li(int i) {
        return RDF.property("_" + i);
    }

    public static class Init {
        public static Resource Alt() {
            return RDF.resource("Alt");
        }

        public static Resource Bag() {
            return RDF.resource("Bag");
        }

        public static Resource _Property() {
            return RDF.resource("Property");
        }

        public static Resource Seq() {
            return RDF.resource("Seq");
        }

        public static Resource Statement() {
            return RDF.resource("Statement");
        }

        public static Resource List() {
            return RDF.resource("List");
        }

        public static Resource nil() {
            return RDF.resource("nil");
        }

        public static Property first() {
            return RDF.property("first");
        }

        public static Property rest() {
            return RDF.property("rest");
        }

        public static Property subject() {
            return RDF.property("subject");
        }

        public static Property predicate() {
            return RDF.property("predicate");
        }

        public static Property object() {
            return RDF.property("object");
        }

        public static Property type() {
            return RDF.property("type");
        }

        public static Property value() {
            return RDF.property("value");
        }

        public static Resource langString() {
            return ResourceFactory.createResource(Init.dtLangString().getURI());
        }

        public static Resource HTML() {
            return ResourceFactory.createResource(Init.dtRDFHTML().getURI());
        }

        public static Resource xmlLiteral() {
            return ResourceFactory.createResource(Init.dtXMLLiteral().getURI());
        }

        public static Resource JSON() {
            return ResourceFactory.createResource(Init.dtRDFJSON().getURI());
        }

        public static Resource CompoundLiteral() {
            return RDF.resource("CompoundLiteral");
        }

        public static Property language() {
            return RDF.property("language");
        }

        public static Property direction() {
            return RDF.property("direction");
        }

        public static RDFDatatype dtRDFHTML() {
            return RDFhtml.rdfHTML;
        }

        public static RDFDatatype dtLangString() {
            return RDFLangString.rdfLangString;
        }

        public static RDFDatatype dtXMLLiteral() {
            return XMLLiteralType.theXMLLiteralType;
        }

        public static RDFDatatype dtRDFJSON() {
            return RDFjson.rdfJSON;
        }
    }

    public static final class Nodes {
        public static final Node Alt = Init.Alt().asNode();
        public static final Node Bag = Init.Bag().asNode();
        public static final Node Property = Init._Property().asNode();
        public static final Node Seq = Init.Seq().asNode();
        public static final Node Statement = Init.Statement().asNode();
        public static final Node List = Init.List().asNode();
        public static final Node nil = Init.nil().asNode();
        public static final Node first = Init.first().asNode();
        public static final Node rest = Init.rest().asNode();
        public static final Node subject = Init.subject().asNode();
        public static final Node predicate = Init.predicate().asNode();
        public static final Node object = Init.object().asNode();
        public static final Node type = Init.type().asNode();
        public static final Node value = Init.value().asNode();
        public static final Node langString = Init.langString().asNode();
        public static final Node HTML = Init.HTML().asNode();
        public static final Node xmlLiteral = Init.xmlLiteral().asNode();
        public static final Node JSON = Init.JSON().asNode();
        public static final Node CompoundLiteral = Init.CompoundLiteral().asNode();
        public static final Node language = Init.language().asNode();
        public static final Node direction = Init.direction().asNode();
    }
}

