/*
 * Decompiled with CFR 0.152.
 */
package net.jini.activation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.activation.ActivationID;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jini.activation.ActivatableInvocationHandler;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;

public final class ActivationExporter
implements Exporter {
    private final ActivationID id;
    private final Exporter underlyingExporter;
    private final ClassLoader loader;
    private boolean used = false;
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    static /* synthetic */ Class class$net$jini$security$proxytrust$ProxyTrust;

    public ActivationExporter(ActivationID id, Exporter underlyingExporter) {
        this(id, underlyingExporter, null);
    }

    public ActivationExporter(ActivationID id, Exporter underlyingExporter, ClassLoader loader) {
        if (id == null || underlyingExporter == null) {
            throw new NullPointerException();
        }
        this.id = id;
        this.underlyingExporter = underlyingExporter;
        this.loader = loader;
    }

    public synchronized Remote export(Remote impl) throws ExportException {
        if (this.used) {
            throw new IllegalStateException("object already exported via this exporter");
        }
        if (impl == null) {
            throw new NullPointerException("impl is null");
        }
        Remote uproxy = this.underlyingExporter.export(impl);
        this.used = true;
        boolean success = false;
        try {
            ClassLoader proxyLoader;
            Class<?> uproxyClass = uproxy.getClass();
            if (this.loader != null) {
                proxyLoader = this.loader;
            } else {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    security.checkPermission(getClassLoaderPermission);
                }
                proxyLoader = uproxyClass.getClassLoader();
            }
            LinkedHashSet interfaceList = new LinkedHashSet();
            boolean isConstrainable = uproxy instanceof RemoteMethodControl;
            boolean checkPublic = !Modifier.isPublic(uproxyClass.getModifiers());
            ActivationExporter.getSuperinterfaces(interfaceList, uproxyClass, isConstrainable, checkPublic);
            Class[] proxyInterfaces = interfaceList.toArray(new Class[interfaceList.size()]);
            ActivatableInvocationHandler handler = new ActivatableInvocationHandler(this.id, uproxy);
            Remote proxy = (Remote)Proxy.newProxyInstance(proxyLoader, proxyInterfaces, (InvocationHandler)handler);
            success = true;
            Remote remote = proxy;
            return remote;
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("proxy creation failed", e);
        }
        finally {
            if (!success) {
                this.unexport(true);
            }
        }
    }

    public synchronized boolean unexport(boolean force) {
        if (!this.used) {
            throw new IllegalStateException("an object has not been exported via this exporter");
        }
        return this.underlyingExporter.unexport(force);
    }

    private static void getSuperinterfaces(Set list, Class cl, boolean isConstrainable, boolean checkPublic) throws ExportException {
        Class superclass = cl.getSuperclass();
        if (superclass != null) {
            ActivationExporter.getSuperinterfaces(list, superclass, isConstrainable, checkPublic);
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> intf = interfaces[i];
            if (checkPublic && !Modifier.isPublic(intf.getModifiers())) {
                throw new ExportException("proxy implements non-public interface");
            }
            if (isConstrainable && intf == (class$net$jini$security$proxytrust$ProxyTrust == null ? ActivationExporter.class$("net.jini.security.proxytrust.ProxyTrust") : class$net$jini$security$proxytrust$ProxyTrust)) continue;
            list.add(intf);
        }
    }
}

