/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SelectionManager {
    private static final int concurrency = 1;
    private static final Logger logger;
    private static final Executor systemThreadPool;
    private final Selector selector;
    private final Pipe.SinkChannel wakeupPipeSink;
    private final Pipe.SourceChannel wakeupPipeSource;
    private final SelectionKey wakeupPipeKey;
    private final ByteBuffer wakeupBuffer = ByteBuffer.allocate(2);
    private final Map registeredChannels = Collections.synchronizedMap(new WeakHashMap());
    private final Object lock = new Object();
    private Thread selectingThread = null;
    private boolean wakeupPending = false;
    private Key renewQueue = null;
    private Key readyQueue = null;
    private final int[] renewMaskRef = new int[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectionManager() throws IOException {
        this.selector = Selector.open();
        Pipe pipe = Pipe.open();
        this.wakeupPipeSink = pipe.sink();
        this.wakeupPipeSource = pipe.source();
        this.wakeupPipeSource.configureBlocking(false);
        this.wakeupPipeKey = this.wakeupPipeSource.register(this.selector, 1);
        for (int i = 0; i < 1; ++i) {
            systemThreadPool.execute(new SelectLoop(), "I/O SelectionManager-" + i);
        }
    }

    public Key register(SelectableChannel channel, SelectionHandler handler) {
        if (this.registeredChannels.containsKey(channel)) {
            throw new IllegalStateException("channel already registered");
        }
        Key key = new Key(channel, handler);
        this.registeredChannels.put(channel, null);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key waitForReadyKey(int[] readyMaskOut) throws InterruptedException {
        Key key;
        Set<SelectionKey> selectedKeys;
        boolean needToClearSelectingThread;
        block36: {
            Object object;
            Key key2;
            block35: {
                if (!$assertionsDisabled && Thread.holdsLock(this.lock)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled) {
                    if (readyMaskOut == null) throw new AssertionError();
                    if (readyMaskOut.length != 1) {
                        throw new AssertionError();
                    }
                }
                needToClearSelectingThread = false;
                selectedKeys = this.selector.selectedKeys();
                try {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        while (this.isReadyQueueEmpty() && this.selectingThread != null) {
                            this.lock.wait();
                        }
                        if (!this.isReadyQueueEmpty()) {
                            Key readyKey = this.removeFromReadyQueue(readyMaskOut);
                            this.lock.notify();
                            key2 = readyKey;
                            // MONITOREXIT @DISABLED, blocks:[0, 34, 7] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                            Object var12_14 = null;
                            if (!needToClearSelectingThread) return key2;
                            object = this.lock;
                            break block35;
                        }
                        if (!$assertionsDisabled && this.selectingThread != null) {
                            throw new AssertionError();
                        }
                        this.selectingThread = Thread.currentThread();
                        needToClearSelectingThread = true;
                        this.processRenewQueue();
                    }
                    while (true) {
                        try {
                            int n = this.selector.select();
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                        }
                        catch (Error e) {
                            if (!e.getMessage().startsWith("POLLNVAL")) throw e;
                            Thread.yield();
                            continue;
                        }
                        catch (CancelledKeyException e) {
                            continue;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                        catch (IOException e) {
                            logger.log(Levels.HANDLED, "thrown by select, continuing", e);
                            continue;
                        }
                        object2 = this.lock;
                        synchronized (object2) {
                            if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                                this.drainWakeupPipe();
                                this.wakeupPending = false;
                                selectedKeys.remove(this.wakeupPipeKey);
                            }
                            if (!selectedKeys.isEmpty()) break;
                            this.processRenewQueue();
                        }
                    }
                    {
                        this.selectingThread = null;
                        needToClearSelectingThread = false;
                        this.lock.notify();
                        Iterator<SelectionKey> iter = selectedKeys.iterator();
                        if (!$assertionsDisabled && !iter.hasNext()) {
                            throw new AssertionError();
                        }
                        while (iter.hasNext()) {
                            SelectionKey selectionKey = iter.next();
                            Key key3 = (Key)selectionKey.attachment();
                            int readyMask = 0;
                            try {
                                readyMask = selectionKey.readyOps();
                                if (!$assertionsDisabled && readyMask == 0) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && (key3.interestMask & readyMask) != readyMask) {
                                    throw new AssertionError();
                                }
                                int newInterestMask = key3.interestMask & ~readyMask;
                                if (!$assertionsDisabled && key3.interestMask != selectionKey.interestOps()) {
                                    throw new AssertionError();
                                }
                                key3.selectionKey.interestOps(newInterestMask);
                                key3.interestMask = newInterestMask;
                            }
                            catch (CancelledKeyException e) {
                                readyMask |= key3.interestMask;
                                key3.interestMask = 0;
                            }
                            this.addOrUpdateReadyQueue(key3, readyMask);
                            iter.remove();
                        }
                        key = this.removeFromReadyQueue(readyMaskOut);
                    }
                    break block36;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (!needToClearSelectingThread) throw throwable;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                            this.drainWakeupPipe();
                            this.wakeupPending = false;
                            selectedKeys.remove(this.wakeupPipeKey);
                        }
                        this.selectingThread = null;
                        needToClearSelectingThread = false;
                        this.lock.notify();
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                    this.drainWakeupPipe();
                    this.wakeupPending = false;
                    selectedKeys.remove(this.wakeupPipeKey);
                }
                this.selectingThread = null;
                needToClearSelectingThread = false;
                this.lock.notify();
                return key2;
            }
        }
        Object var12_15 = null;
        if (!needToClearSelectingThread) return key;
        Object object = this.lock;
        synchronized (object) {
            if (this.wakeupPending && selectedKeys.contains(this.wakeupPipeKey)) {
                this.drainWakeupPipe();
                this.wakeupPending = false;
                selectedKeys.remove(this.wakeupPipeKey);
            }
            this.selectingThread = null;
            needToClearSelectingThread = false;
            this.lock.notify();
            return key;
        }
    }

    private void wakeupSelector() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.wakeupPending) {
            throw new AssertionError();
        }
        this.wakeupBuffer.clear().limit(1);
        try {
            this.wakeupPipeSink.write(this.wakeupBuffer);
        }
        catch (IOException e) {
            AssertionError error = new AssertionError((Object)"unexpected I/O exception");
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    private void drainWakeupPipe() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.selectingThread == null) {
            throw new AssertionError();
        }
        do {
            this.wakeupBuffer.clear();
            try {
                this.wakeupPipeSource.read(this.wakeupBuffer);
            }
            catch (IOException e) {
                AssertionError error = new AssertionError((Object)"unexpected I/O exception");
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        } while (!this.wakeupBuffer.hasRemaining());
    }

    private void processRenewQueue() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.selectingThread == null) {
            throw new AssertionError();
        }
        while (!this.isRenewQueueEmpty()) {
            Key key = this.removeFromRenewQueue(this.renewMaskRef);
            int renewMask = this.renewMaskRef[0];
            if (!$assertionsDisabled && renewMask == 0) {
                throw new AssertionError();
            }
            if (key.selectionKey == null) {
                if (!($assertionsDisabled || key.interestMask == 0 && key.readyMask == 0)) {
                    throw new AssertionError();
                }
                try {
                    key.selectionKey = key.channel.register(this.selector, renewMask);
                    key.selectionKey.attach(key);
                    key.interestMask = renewMask;
                }
                catch (ClosedChannelException e) {
                    this.addOrUpdateReadyQueue(key, renewMask);
                }
                catch (IllegalBlockingModeException e) {
                    this.addOrUpdateReadyQueue(key, renewMask);
                }
                continue;
            }
            if (!$assertionsDisabled && (key.interestMask & renewMask) != 0) {
                throw new AssertionError();
            }
            int newInterestMask = key.interestMask | renewMask;
            try {
                if (!$assertionsDisabled && key.interestMask != key.selectionKey.interestOps()) {
                    throw new AssertionError();
                }
                key.selectionKey.interestOps(newInterestMask);
                key.interestMask = newInterestMask;
            }
            catch (CancelledKeyException e) {
                this.addOrUpdateReadyQueue(key, newInterestMask);
                key.interestMask = 0;
            }
            if (!$assertionsDisabled && (key.interestMask & key.readyMask) != 0) {
                throw new AssertionError();
            }
        }
    }

    private boolean isRenewQueueEmpty() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        return this.renewQueue == null;
    }

    private Key removeFromRenewQueue(int[] renewMaskOut) {
        if (!($assertionsDisabled || renewMaskOut != null && renewMaskOut.length == 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        Key key = this.renewQueue;
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !key.onRenewQueue) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key.renewMask == 0) {
            throw new AssertionError();
        }
        renewMaskOut[0] = key.renewMask;
        key.renewMask = 0;
        this.renewQueue = key.renewQueueNext;
        key.renewQueueNext = null;
        key.onRenewQueue = false;
        return key;
    }

    private void addOrUpdateRenewQueue(Key key, int newRenewMask) {
        if (!$assertionsDisabled && newRenewMask == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!key.onRenewQueue) {
            if (!$assertionsDisabled && key.renewMask != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && key.renewQueueNext != null) {
                throw new AssertionError();
            }
            key.renewMask = newRenewMask;
            key.renewQueueNext = this.renewQueue;
            this.renewQueue = key;
            key.onRenewQueue = true;
        } else {
            if (!$assertionsDisabled && key.renewMask == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && (key.renewMask & newRenewMask) != 0) {
                throw new AssertionError();
            }
            key.renewMask |= newRenewMask;
        }
    }

    private boolean isReadyQueueEmpty() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        return this.readyQueue == null;
    }

    private Key removeFromReadyQueue(int[] readyMaskOut) {
        if (!($assertionsDisabled || readyMaskOut != null && readyMaskOut.length == 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        Key key = this.readyQueue;
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !key.onReadyQueue) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key.readyMask == 0) {
            throw new AssertionError();
        }
        readyMaskOut[0] = key.readyMask;
        key.readyMask = 0;
        this.readyQueue = key.readyQueueNext;
        key.readyQueueNext = null;
        key.onReadyQueue = false;
        return key;
    }

    private void addOrUpdateReadyQueue(Key key, int newReadyMask) {
        if (!$assertionsDisabled && newReadyMask == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!key.onReadyQueue) {
            if (!$assertionsDisabled && key.readyMask != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && key.readyQueueNext != null) {
                throw new AssertionError();
            }
            key.readyMask = newReadyMask;
            key.readyQueueNext = this.readyQueue;
            this.readyQueue = key;
            key.onReadyQueue = true;
        } else {
            if (!$assertionsDisabled && key.readyMask == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && (key.readyMask & newReadyMask) != 0) {
                throw new AssertionError();
            }
            key.readyMask |= newReadyMask;
        }
    }

    static {
        $assertionsDisabled = !SelectionManager.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.sun.jini.jeri.internal.runtime.SelectionManager");
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    }

    private class SelectLoop
    implements Runnable {
        private long lastExceptionTime = 0L;
        private int recentExceptionCount;

        private SelectLoop() {
        }

        public void run() {
            int[] readyMaskRef = new int[1];
            while (true) {
                try {
                    while (true) {
                        Key readyKey = SelectionManager.this.waitForReadyKey(readyMaskRef);
                        readyKey.handler.handleSelection(readyMaskRef[0], readyKey);
                    }
                }
                catch (Throwable t) {
                    try {
                        logger.log(Level.WARNING, "select loop throws", t);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.throttleLoopOnException();
                    continue;
                }
                break;
            }
        }

        private void throttleLoopOnException() {
            long now = System.currentTimeMillis();
            if (this.lastExceptionTime == 0L || now - this.lastExceptionTime > 5000L) {
                this.lastExceptionTime = now;
                this.recentExceptionCount = 0;
            } else if (++this.recentExceptionCount >= 10) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final class Key {
        final SelectableChannel channel;
        final SelectionHandler handler;
        SelectionKey selectionKey = null;
        int interestMask = 0;
        boolean onRenewQueue = false;
        Key renewQueueNext = null;
        int renewMask = 0;
        boolean onReadyQueue = false;
        Key readyQueueNext = null;
        int readyMask = 0;

        Key(SelectableChannel channel, SelectionHandler handler) {
            this.channel = channel;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewInterestMask(int mask) throws ClosedChannelException {
            if (!this.channel.isOpen()) {
                throw new ClosedChannelException();
            }
            if ((mask & ~this.channel.validOps()) != 0) {
                throw new IllegalArgumentException("invalid mask " + mask + " (valid mask " + this.channel.validOps() + ")");
            }
            if (this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            Object object = SelectionManager.this.lock;
            synchronized (object) {
                int delta = mask & ~(this.renewMask | this.interestMask | this.readyMask);
                if (delta != 0) {
                    SelectionManager.this.addOrUpdateRenewQueue(this, delta);
                    if (SelectionManager.this.selectingThread != null && !SelectionManager.this.wakeupPending) {
                        SelectionManager.this.wakeupSelector();
                        SelectionManager.this.wakeupPending = true;
                    }
                }
            }
        }
    }

    public static interface SelectionHandler {
        public void handleSelection(int var1, Key var2);
    }
}

