/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import java.util.Arrays;
import net.jini.core.lookup.ServiceRegistrar;

public class UnicastResponse {
    protected String host;
    protected int port;
    protected String[] groups;
    protected ServiceRegistrar registrar;

    public UnicastResponse(String host, int port, String[] groups, ServiceRegistrar registrar) {
        String[] stringArray = groups = groups != null ? (String[])groups.clone() : new String[]{};
        if (host == null || registrar == null || Arrays.asList(groups).contains(null)) {
            throw new NullPointerException();
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.groups = groups;
        this.registrar = registrar;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return (String[])this.groups.clone();
    }

    public ServiceRegistrar getRegistrar() {
        return this.registrar;
    }

    public String toString() {
        return "UnicastResponse[" + this.host + ":" + this.port + ", " + Arrays.asList(this.groups) + ", " + this.registrar + "]";
    }
}

