/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

public class HTMLUtility {
    public static String escapeForXHTML(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(len + 20);
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("&#34;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block8;
                }
                case '/': {
                    sb.append("&#47;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeForXMLName(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(len + 20);
        char ch = s.charAt(0);
        if (Character.isDigit(ch)) {
            sb.append("_num_");
        }
        block21: for (int i = 0; i < len; ++i) {
            ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("_quote_");
                    continue block21;
                }
                case '\'': {
                    sb.append("_apos_");
                    continue block21;
                }
                case '&': {
                    sb.append("_amp_");
                    continue block21;
                }
                case '<': {
                    sb.append("_lt_");
                    continue block21;
                }
                case '>': {
                    sb.append("_gt_");
                    continue block21;
                }
                case '$': {
                    sb.append("_dollar_");
                    continue block21;
                }
                case ':': {
                    sb.append("_colon_");
                    continue block21;
                }
                case '~': {
                    sb.append("_tilda_");
                    continue block21;
                }
                case '(': {
                    sb.append("_lparen_");
                    continue block21;
                }
                case ')': {
                    sb.append("_rparen_");
                    continue block21;
                }
                case ',': {
                    sb.append("_comma_");
                    continue block21;
                }
                case '=': {
                    sb.append("_eq_");
                    continue block21;
                }
                case '!': {
                    sb.append("_bang_");
                    continue block21;
                }
                case '?': {
                    sb.append("_quest_");
                    continue block21;
                }
                case '/': {
                    sb.append("_fw_slash_");
                    continue block21;
                }
                case '\\': {
                    sb.append("_bk_slash_");
                    continue block21;
                }
                case ';': {
                    sb.append("_semicolon_");
                    continue block21;
                }
                case '.': {
                    sb.append("_period_");
                    continue block21;
                }
                case '`': {
                    sb.append("_tic_");
                    continue block21;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

