/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.jet.math.Arithmetic;
import cern.jet.math.Constants;

public class Bessel
extends Constants {
    protected static final double[] A_i0 = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
    protected static final double[] B_i0 = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
    protected static final double[] A_i1 = new double[]{2.7779141127610464E-18, -2.111421214358166E-17, 1.5536319577362005E-16, -1.1055969477353862E-15, 7.600684294735408E-15, -5.042185504727912E-14, 3.223793365945575E-13, -1.9839743977649436E-12, 1.1736186298890901E-11, -6.663489723502027E-11, 3.625590281552117E-10, -1.8872497517228294E-9, 9.381537386495773E-9, -4.445059128796328E-8, 2.0032947535521353E-7, -8.568720264695455E-7, 3.4702513081376785E-6, -1.3273163656039436E-5, 4.781565107550054E-5, -1.6176081582589674E-4, 5.122859561685758E-4, -0.0015135724506312532, 0.004156422944312888, -0.010564084894626197, 0.024726449030626516, -0.05294598120809499, 0.1026436586898471, -0.17641651835783406, 0.25258718644363365};
    protected static final double[] B_i1 = new double[]{7.517296310842105E-18, 4.414348323071708E-18, -4.6503053684893586E-17, -3.209525921993424E-17, 2.96262899764595E-16, 3.3082023109209285E-16, -1.8803547755107825E-15, -3.8144030724370075E-15, 1.0420276984128802E-14, 4.272440016711951E-14, -2.1015418427726643E-14, -4.0835511110921974E-13, -7.198551776245908E-13, 2.0356285441470896E-12, 1.4125807436613782E-11, 3.2526035830154884E-11, -1.8974958123505413E-11, -5.589743462196584E-10, -3.835380385964237E-9, -2.6314688468895196E-8, -2.512236237870209E-7, -3.882564808877691E-6, -1.1058893876262371E-4, -0.009761097491361469, 0.7785762350182801};
    protected static final double[] A_k0 = new double[]{1.374465435613523E-16, 4.25981614279661E-14, 1.0349695257633842E-11, 1.904516377220209E-9, 2.5347910790261494E-7, 2.286212103119452E-5, 0.001264615411446926, 0.0359799365153615, 0.3442898999246285, -0.5353273932339028};
    protected static final double[] B_k0 = new double[]{5.300433772686263E-18, -1.6475804301524212E-17, 5.2103915050390274E-17, -1.678231096805412E-16, 5.512055978524319E-16, -1.848593377343779E-15, 6.3400764774050706E-15, -2.2275133269916698E-14, 8.032890775363575E-14, -2.9800969231727303E-13, 1.140340588208475E-12, -4.514597883373944E-12, 1.8559491149547177E-11, -7.957489244477107E-11, 3.577397281400301E-10, -1.69753450938906E-9, 8.574034017414225E-9, -4.660489897687948E-8, 2.766813639445015E-7, -1.8317555227191195E-6, 1.39498137188765E-5, -1.2849549581627802E-4, 0.0015698838857300533, -0.0314481013119645, 2.4403030820659555};
    protected static final double[] A_k1 = new double[]{-7.023863479386288E-18, -2.427449850519366E-15, -6.666901694199329E-13, -1.4114883926335278E-10, -2.213387630734726E-8, -2.4334061415659684E-6, -1.730288957513052E-4, -0.006975723859639864, -0.12261118082265715, -0.3531559607765449, 1.5253002273389478};
    protected static final double[] B_k1 = new double[]{-5.756744483665017E-18, 1.7940508731475592E-17, -5.689462558442859E-17, 1.838093544366639E-16, -6.057047248373319E-16, 2.038703165624334E-15, -7.019837090418314E-15, 2.4771544244813043E-14, -8.976705182324994E-14, 3.3484196660784293E-13, -1.2891739609510289E-12, 5.13963967348173E-12, -2.1299678384275683E-11, 9.218315187605006E-11, -4.1903547593418965E-10, 2.015049755197033E-9, -1.0345762465678097E-8, 5.7410841254500495E-8, -3.5019606030878126E-7, 2.406484947837217E-6, -1.936197974166083E-5, 1.9521551847135162E-4, -0.002857816859622779, 0.10392373657681724, 2.7206261904844427};

    protected Bessel() {
    }

    public static double i0(double x) throws ArithmeticException {
        if (x < 0.0) {
            x = -x;
        }
        if (x <= 8.0) {
            double y = x / 2.0 - 2.0;
            return Math.exp(x) * Arithmetic.chbevl(y, A_i0, 30);
        }
        return Math.exp(x) * Arithmetic.chbevl(32.0 / x - 2.0, B_i0, 25) / Math.sqrt(x);
    }

    public static double i0e(double x) throws ArithmeticException {
        if (x < 0.0) {
            x = -x;
        }
        if (x <= 8.0) {
            double y = x / 2.0 - 2.0;
            return Arithmetic.chbevl(y, A_i0, 30);
        }
        return Arithmetic.chbevl(32.0 / x - 2.0, B_i0, 25) / Math.sqrt(x);
    }

    public static double i1(double x) throws ArithmeticException {
        double z = Math.abs(x);
        if (z <= 8.0) {
            double y = z / 2.0 - 2.0;
            z = Arithmetic.chbevl(y, A_i1, 29) * z * Math.exp(z);
        } else {
            z = Math.exp(z) * Arithmetic.chbevl(32.0 / z - 2.0, B_i1, 25) / Math.sqrt(z);
        }
        if (x < 0.0) {
            z = -z;
        }
        return z;
    }

    public static double i1e(double x) throws ArithmeticException {
        double z = Math.abs(x);
        if (z <= 8.0) {
            double y = z / 2.0 - 2.0;
            z = Arithmetic.chbevl(y, A_i1, 29) * z;
        } else {
            z = Arithmetic.chbevl(32.0 / z - 2.0, B_i1, 25) / Math.sqrt(z);
        }
        if (x < 0.0) {
            z = -z;
        }
        return z;
    }

    public static double j0(double x) throws ArithmeticException {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = 5.7568490574E10 + y * (-1.3362590354E10 + y * (6.516196407E8 + y * (-1.121442418E7 + y * (77392.33017 + y * -184.9052456))));
            double ans2 = 5.7568490411E10 + y * (1.029532985E9 + y * (9494680.718 + y * (59272.64853 + y * (267.8532712 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double y = z * z;
        double xx = ax - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 - y * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
    }

    public static double j1(double x) throws ArithmeticException {
        double d;
        double ax = Math.abs(x);
        if (d < 8.0) {
            double y = x * x;
            double ans1 = x * (7.2362614232E10 + y * (-7.895059235E9 + y * (2.423968531E8 + y * (-2972611.439 + y * (15704.4826 + y * -30.16036606)))));
            double ans2 = 1.44725228442E11 + y * (2.300535178E9 + y * (1.858330474E7 + y * (99447.43394 + y * (376.9991397 + y * 1.0))));
            return ans1 / ans2;
        }
        double z = 8.0 / ax;
        double xx = ax - 2.356194491;
        double y = z * z;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        double ans = Math.sqrt(0.636619772 / ax) * (Math.cos(xx) * ans1 - z * Math.sin(xx) * ans2);
        if (x < 0.0) {
            ans = -ans;
        }
        return ans;
    }

    public static double jn(int n, double x) throws ArithmeticException {
        double ans;
        double ACC = 40.0;
        double BIGNO = 1.0E10;
        double BIGNI = 1.0E-10;
        if (n == 0) {
            return Bessel.j0(x);
        }
        if (n == 1) {
            return Bessel.j1(x);
        }
        double ax = Math.abs(x);
        if (ax == 0.0) {
            return 0.0;
        }
        if (ax > (double)n) {
            double tox = 2.0 / ax;
            double bjm = Bessel.j0(ax);
            double bj = Bessel.j1(ax);
            for (int j = 1; j < n; ++j) {
                double bjp = (double)j * tox * bj - bjm;
                bjm = bj;
                bj = bjp;
            }
            ans = bj;
        } else {
            double tox = 2.0 / ax;
            int m = 2 * ((n + (int)Math.sqrt(40.0 * (double)n)) / 2);
            boolean jsum = false;
            double sum = 0.0;
            ans = 0.0;
            double bjp = 0.0;
            double bj = 1.0;
            for (int j = m; j > 0; --j) {
                double bjm = (double)j * tox * bj - bjp;
                bjp = bj;
                bj = bjm;
                if (Math.abs(bj) > 1.0E10) {
                    bj *= 1.0E-10;
                    bjp *= 1.0E-10;
                    ans *= 1.0E-10;
                    sum *= 1.0E-10;
                }
                if (jsum) {
                    sum += bj;
                }
                boolean bl = jsum = !jsum;
                if (j != n) continue;
                ans = bjp;
            }
            sum = 2.0 * sum - bj;
            ans /= sum;
        }
        return x < 0.0 && n % 2 == 1 ? -ans : ans;
    }

    public static double k0(double x) throws ArithmeticException {
        if (x <= 0.0) {
            throw new ArithmeticException();
        }
        if (x <= 2.0) {
            double y = x * x - 2.0;
            y = Arithmetic.chbevl(y, A_k0, 10) - Math.log(0.5 * x) * Bessel.i0(x);
            return y;
        }
        double z = 8.0 / x - 2.0;
        double y = Math.exp(-x) * Arithmetic.chbevl(z, B_k0, 25) / Math.sqrt(x);
        return y;
    }

    public static double k0e(double x) throws ArithmeticException {
        if (x <= 0.0) {
            throw new ArithmeticException();
        }
        if (x <= 2.0) {
            double y = x * x - 2.0;
            y = Arithmetic.chbevl(y, A_k0, 10) - Math.log(0.5 * x) * Bessel.i0(x);
            return y * Math.exp(x);
        }
        double y = Arithmetic.chbevl(8.0 / x - 2.0, B_k0, 25) / Math.sqrt(x);
        return y;
    }

    public static double k1(double x) throws ArithmeticException {
        double z = 0.5 * x;
        if (z <= 0.0) {
            throw new ArithmeticException();
        }
        if (x <= 2.0) {
            double y = x * x - 2.0;
            y = Math.log(z) * Bessel.i1(x) + Arithmetic.chbevl(y, A_k1, 11) / x;
            return y;
        }
        return Math.exp(-x) * Arithmetic.chbevl(8.0 / x - 2.0, B_k1, 25) / Math.sqrt(x);
    }

    public static double k1e(double x) throws ArithmeticException {
        if (x <= 0.0) {
            throw new ArithmeticException();
        }
        if (x <= 2.0) {
            double y = x * x - 2.0;
            y = Math.log(0.5 * x) * Bessel.i1(x) + Arithmetic.chbevl(y, A_k1, 11) / x;
            return y * Math.exp(x);
        }
        return Arithmetic.chbevl(8.0 / x - 2.0, B_k1, 25) / Math.sqrt(x);
    }

    public static double kn(int nn, double x) throws ArithmeticException {
        double t;
        double EUL = 0.5772156649015329;
        double MAXNUM = Double.MAX_VALUE;
        int MAXFAC = 31;
        int n = nn < 0 ? -nn : nn;
        if (n > 31) {
            throw new ArithmeticException("Overflow");
        }
        if (x <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (x <= 9.55) {
            double t2;
            double s;
            double k;
            double ans = 0.0;
            double z0 = 0.25 * x * x;
            double fn = 1.0;
            double pn = 0.0;
            double zmn = 1.0;
            double tox = 2.0 / x;
            if (n > 0) {
                int i;
                pn = -0.5772156649015329;
                k = 1.0;
                for (i = 1; i < n; ++i) {
                    pn += 1.0 / k;
                    fn *= (k += 1.0);
                }
                zmn = tox;
                if (n == 1) {
                    ans = 1.0 / x;
                } else {
                    double nk1f = fn / (double)n;
                    double kf = 1.0;
                    s = nk1f;
                    double z = -z0;
                    double zn = 1.0;
                    for (i = 1; i < n; ++i) {
                        t2 = (nk1f /= (double)(n - i)) * (zn *= z) / (kf *= (double)i);
                        s += t2;
                        if (Double.MAX_VALUE - Math.abs(t2) < Math.abs(s)) {
                            throw new ArithmeticException("Overflow");
                        }
                        if (tox > 1.0 && Double.MAX_VALUE / tox < zmn) {
                            throw new ArithmeticException("Overflow");
                        }
                        zmn *= tox;
                    }
                    t2 = Math.abs(s *= 0.5);
                    if (zmn > 1.0 && Double.MAX_VALUE / zmn < t2) {
                        throw new ArithmeticException("Overflow");
                    }
                    if (t2 > 1.0 && Double.MAX_VALUE / t2 < zmn) {
                        throw new ArithmeticException("Overflow");
                    }
                    ans = s * zmn;
                }
            }
            double tlg = 2.0 * Math.log(0.5 * x);
            double pk = -0.5772156649015329;
            if (n == 0) {
                pn = pk;
                t2 = 1.0;
            } else {
                pn += 1.0 / (double)n;
                t2 = 1.0 / fn;
            }
            s = (pk + pn - tlg) * t2;
            k = 1.0;
            while (Math.abs(t2 / (s += ((pk += 1.0 / (k += 1.0)) + (pn += 1.0 / (k + (double)n)) - tlg) * (t2 *= z0 / (k * (k + (double)n))))) > (double)1.110223E-16f) {
            }
            s = 0.5 * s / zmn;
            if ((n & 1) > 0) {
                s = -s;
            }
            return ans += s;
        }
        if (x > 709.782712893384) {
            throw new ArithmeticException("Underflow");
        }
        double k = n;
        double pn = 4.0 * k * k;
        double pk = 1.0;
        double z0 = 8.0 * x;
        double fn = 1.0;
        double s = t = 1.0;
        double nkf = Double.MAX_VALUE;
        int i = 0;
        do {
            double z = pn - pk * pk;
            t = t * z / (fn * z0);
            double nk1f = Math.abs(t);
            if (i >= n && nk1f > nkf) {
                double ans = Math.exp(-x) * Math.sqrt(Math.PI / (2.0 * x)) * s;
                return ans;
            }
            nkf = nk1f;
            fn += 1.0;
            pk += 2.0;
            ++i;
        } while (Math.abs(t / (s += t)) > (double)1.110223E-16f);
        double ans = Math.exp(-x) * Math.sqrt(Math.PI / (2.0 * x)) * s;
        return ans;
    }

    public static double y0(double x) throws ArithmeticException {
        if (x < 8.0) {
            double y = x * x;
            double ans1 = -2.957821389E9 + y * (7.062834065E9 + y * (-5.123598036E8 + y * (1.087988129E7 + y * (-86327.92757 + y * 228.4622733))));
            double ans2 = 4.0076544269E10 + y * (7.452499648E8 + y * (7189466.438 + y * (47447.2647 + y * (226.1030244 + y * 1.0))));
            return ans1 / ans2 + 0.636619772 * Bessel.j0(x) * Math.log(x);
        }
        double z = 8.0 / x;
        double y = z * z;
        double xx = x - 0.785398164;
        double ans1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
        double ans2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 + y * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / x) * (Math.sin(xx) * ans1 + z * Math.cos(xx) * ans2);
    }

    public static double y1(double x) throws ArithmeticException {
        if (x < 8.0) {
            double y = x * x;
            double ans1 = x * (-4.900604943E12 + y * (1.27527439E12 + y * (-5.153438139E10 + y * (7.349264551E8 + y * (-4237922.726 + y * 8511.937935)))));
            double ans2 = 2.49958057E13 + y * (4.244419664E11 + y * (3.733650367E9 + y * (2.245904002E7 + y * (102042.605 + y * (354.9632885 + y)))));
            return ans1 / ans2 + 0.636619772 * (Bessel.j1(x) * Math.log(x) - 1.0 / x);
        }
        double z = 8.0 / x;
        double y = z * z;
        double xx = x - 2.356194491;
        double ans1 = 1.0 + y * (0.00183105 + y * (-3.516396496E-5 + y * (2.457520174E-6 + y * -2.40337019E-7)));
        double ans2 = 0.04687499995 + y * (-2.002690873E-4 + y * (8.449199096E-6 + y * (-8.8228987E-7 + y * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / x) * (Math.sin(xx) * ans1 + z * Math.cos(xx) * ans2);
    }

    public static double yn(int n, double x) throws ArithmeticException {
        if (n == 0) {
            return Bessel.y0(x);
        }
        if (n == 1) {
            return Bessel.y1(x);
        }
        double tox = 2.0 / x;
        double by = Bessel.y1(x);
        double bym = Bessel.y0(x);
        for (int j = 1; j < n; ++j) {
            double byp = (double)j * tox * by - bym;
            bym = by;
            by = byp;
        }
        return by;
    }
}

