/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.bitvector;

public class QuickBitVector {
    protected static final int ADDRESS_BITS_PER_UNIT = 6;
    protected static final int BITS_PER_UNIT = 64;
    protected static final int BIT_INDEX_MASK = 63;
    private static final long[] pows = QuickBitVector.precomputePows();

    protected QuickBitVector() {
    }

    public static final long bitMaskWithBitsSetFromTo(int from, int to) {
        return pows[to - from + 1] << from;
    }

    public static void clear(long[] bits, int bitIndex) {
        int n = bitIndex >> 6;
        bits[n] = bits[n] & (1L << (bitIndex & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean get(long[] bits, int bitIndex) {
        return (bits[bitIndex >> 6] & 1L << (bitIndex & 0x3F)) != 0L;
    }

    public static long getLongFromTo(long[] bits, int from, int to) {
        if (from > to) {
            return 0L;
        }
        int fromIndex = from >> 6;
        int toIndex = to >> 6;
        int fromOffset = from & 0x3F;
        int toOffset = to & 0x3F;
        if (fromIndex == toIndex) {
            long mask = QuickBitVector.bitMaskWithBitsSetFromTo(fromOffset, toOffset);
            return (bits[fromIndex] & mask) >>> fromOffset;
        }
        long mask = QuickBitVector.bitMaskWithBitsSetFromTo(fromOffset, 63);
        long x1 = (bits[fromIndex] & mask) >>> fromOffset;
        mask = QuickBitVector.bitMaskWithBitsSetFromTo(0, toOffset);
        long x2 = (bits[toIndex] & mask) << 64 - fromOffset;
        return x1 | x2;
    }

    public static int leastSignificantBit(int value) {
        int i = -1;
        while (++i < 32 && (1 << i & value) == 0) {
        }
        return i;
    }

    public static long[] makeBitVector(int size, int bitsPerElement) {
        int nBits = size * bitsPerElement;
        int unitIndex = nBits - 1 >> 6;
        long[] bitVector = new long[unitIndex + 1];
        return bitVector;
    }

    public static int mostSignificantBit(int value) {
        int i = 32;
        while (--i >= 0 && (1 << i & value) == 0) {
        }
        return i;
    }

    protected static int offset(int bitIndex) {
        return bitIndex & 0x3F;
    }

    private static long[] precomputePows() {
        long[] pows = new long[65];
        long value = -1L;
        int i = 65;
        while (--i >= 1) {
            pows[i] = value >>> 64 - i;
        }
        pows[0] = 0L;
        return pows;
    }

    public static void put(long[] bits, int bitIndex, boolean value) {
        if (value) {
            QuickBitVector.set(bits, bitIndex);
        } else {
            QuickBitVector.clear(bits, bitIndex);
        }
    }

    public static void putLongFromTo(long[] bits, long value, int from, int to) {
        if (from > to) {
            return;
        }
        int fromIndex = from >> 6;
        int toIndex = to >> 6;
        int fromOffset = from & 0x3F;
        int toOffset = to & 0x3F;
        long mask = QuickBitVector.bitMaskWithBitsSetFromTo(to - from + 1, 63);
        long cleanValue = value & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (fromIndex == toIndex) {
            long shiftedValue = cleanValue << fromOffset;
            mask = QuickBitVector.bitMaskWithBitsSetFromTo(fromOffset, toOffset);
            bits[fromIndex] = bits[fromIndex] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | shiftedValue;
            return;
        }
        long shiftedValue = cleanValue << fromOffset;
        mask = QuickBitVector.bitMaskWithBitsSetFromTo(fromOffset, 63);
        bits[fromIndex] = bits[fromIndex] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | shiftedValue;
        shiftedValue = cleanValue >>> 64 - fromOffset;
        mask = QuickBitVector.bitMaskWithBitsSetFromTo(0, toOffset);
        bits[toIndex] = bits[toIndex] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | shiftedValue;
    }

    public static void set(long[] bits, int bitIndex) {
        int n = bitIndex >> 6;
        bits[n] = bits[n] | 1L << (bitIndex & 0x3F);
    }

    protected static int unit(int bitIndex) {
        return bitIndex >> 6;
    }
}

