/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.postgis.util.VersionFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger logger = LoggerFactory.getLogger(VersionUtil.class);
    public static final String NONEXISTENT_FUNCTION_ERROR_MESSAGE_CONTENT = "does not exist";
    public static final String POSTGIS_SERVER_VERSION_SEPERATOR = ".";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 60;

    public static String getVersionString(Connection connection, String function) throws SQLException {
        String result;
        block14: {
            Objects.requireNonNull(connection, "Unable to retrieve version string from a null connection");
            Objects.requireNonNull(function, "Unable to retrieve version string for a null function");
            VersionUtil.validateConnection(connection);
            result = "-- unavailable -- ";
            try (PreparedStatement statement = connection.prepareStatement("SELECT " + function + "()");
                 ResultSet resultSet = statement.executeQuery();){
                String version;
                result = resultSet.next() ? ((version = resultSet.getString(1)) != null ? version.trim() : "-- null result --") : "-- no result --";
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().contains(NONEXISTENT_FUNCTION_ERROR_MESSAGE_CONTENT)) break block14;
                throw sqle;
            }
        }
        return result;
    }

    public static String retrievePostGISServerVersionString(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "Unable to retrieve PostGIS server version string from a null connection");
        VersionUtil.validateConnection(connection);
        String postGISVersionString = VersionUtil.getVersionString(connection, VersionFunctions.POSTGIS_VERSION.toString());
        logger.debug("retrieved PostGIS server version string: [{}]", (Object)postGISVersionString);
        return postGISVersionString;
    }

    public static String retrievePostGISServerVersion(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "Unable to retrieve PostGIS version from a null connection");
        VersionUtil.validateConnection(connection);
        String versionString = VersionUtil.retrievePostGISServerVersionString(connection);
        String versionTerminatorString = " ";
        int versionTerminatorIndex = versionString.indexOf(" ");
        String version = versionTerminatorIndex == -1 ? versionString : versionString.substring(0, versionTerminatorIndex);
        logger.debug("retrieved PostGIS server version: [{}]", (Object)version);
        return version;
    }

    public static String retrievePostGISServerMajorVersion(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "Unable to retrieve PostGIS major version from a null connection");
        VersionUtil.validateConnection(connection);
        String version = VersionUtil.retrievePostGISServerVersion(connection);
        int majorVersionSeperatorIndex = version.indexOf(POSTGIS_SERVER_VERSION_SEPERATOR);
        String majorVersion = majorVersionSeperatorIndex == -1 ? version : version.substring(0, majorVersionSeperatorIndex);
        logger.debug("retrieved postGIS major version string: [{}]", (Object)majorVersion);
        return majorVersion;
    }

    public static String retrievePostGISServerMinorVersion(Connection connection) throws SQLException {
        int minorVersionSeperatorIndex;
        Objects.requireNonNull(connection, "Unable to retrieve PostGIS minor version from a null connection");
        VersionUtil.validateConnection(connection);
        String version = VersionUtil.retrievePostGISServerVersion(connection);
        int majorVersionSeperatorIndex = version.indexOf(POSTGIS_SERVER_VERSION_SEPERATOR);
        String minorVersion = majorVersionSeperatorIndex == -1 ? "" : ((minorVersionSeperatorIndex = version.indexOf(POSTGIS_SERVER_VERSION_SEPERATOR, majorVersionSeperatorIndex + 1)) == -1 ? version.substring(majorVersionSeperatorIndex + 1) : version.substring(majorVersionSeperatorIndex + 1, minorVersionSeperatorIndex));
        logger.debug("retrieved postGIS minor version string: [{}]", (Object)minorVersion);
        return minorVersion;
    }

    private static void validateConnection(Connection connection) throws SQLException {
        if (!connection.isValid(60)) {
            throw new SQLException("The connection was not valid.");
        }
    }
}

