/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCache;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.structures.SubQuery;

public class SourceSelectionMemoryCache
implements SourceSelectionCache {
    public static final String DEFAULT_CACHE_SPEC = "maximumSize=1000,expireAfterWrite=6h";
    private final Cache<SubQuery, Entry> cache;

    public SourceSelectionMemoryCache() {
        this(DEFAULT_CACHE_SPEC);
    }

    public SourceSelectionMemoryCache(String cacheSpec) {
        cacheSpec = cacheSpec == null ? DEFAULT_CACHE_SPEC : cacheSpec;
        this.cache = CacheBuilder.from((CacheBuilderSpec)CacheBuilderSpec.parse((String)cacheSpec)).build();
    }

    @Override
    public SourceSelectionCache.StatementSourceAssurance getAssurance(SubQuery subQuery, Endpoint endpoint) {
        if (subQuery.isUnbound()) {
            return SourceSelectionCache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS;
        }
        Entry entry = (Entry)this.cache.getIfPresent((Object)subQuery);
        if (entry != null) {
            return entry.getAssurance(endpoint);
        }
        if (subQuery.object() != null && this.getAssurance(new SubQuery(subQuery.subject(), subQuery.predicate(), null), endpoint).equals((Object)SourceSelectionCache.StatementSourceAssurance.NONE)) {
            return SourceSelectionCache.StatementSourceAssurance.NONE;
        }
        return SourceSelectionCache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS;
    }

    @Override
    public void updateInformation(SubQuery subQuery, Endpoint endpoint, boolean hasStatements) {
        this.updateCacheEntry(subQuery, endpoint, hasStatements);
        this.updateInferredInformation(subQuery, endpoint, hasStatements);
    }

    private void updateCacheEntry(SubQuery subQuery, Endpoint endpoint, boolean hasStatements) {
        try {
            Entry entry = (Entry)this.cache.get((Object)subQuery, () -> new Entry());
            entry.setEndpointInfo(endpoint, hasStatements);
        }
        catch (ExecutionException e) {
            throw new FedXRuntimeException(e);
        }
    }

    private void updateInferredInformation(SubQuery subQuery, Endpoint endpoint, boolean hasStatements) {
        if (!hasStatements) {
            return;
        }
        if (subQuery.object() != null && subQuery.predicate() != null) {
            this.updateCacheEntry(new SubQuery(subQuery.subject(), subQuery.predicate(), null), endpoint, hasStatements);
        }
    }

    private static class Entry {
        final Map<String, SourceSelectionCache.StatementSourceAssurance> endpointToInformation = Maps.newConcurrentMap();

        private Entry() {
        }

        public void setEndpointInfo(Endpoint e, boolean hasStatements) {
            this.endpointToInformation.put(e.getId(), hasStatements ? SourceSelectionCache.StatementSourceAssurance.HAS_REMOTE_STATEMENTS : SourceSelectionCache.StatementSourceAssurance.NONE);
        }

        public SourceSelectionCache.StatementSourceAssurance getAssurance(Endpoint e) {
            return this.endpointToInformation.getOrDefault(e.getId(), SourceSelectionCache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS);
        }
    }
}

