/*
 * Decompiled with CFR 0.152.
 */
package org.apache.system;

import org.apache.log4j.Logger;
import org.apache.system.CPUParser;

public final class SystemUtil {
    private static final int m_processors;
    private static final String m_cpuInfo;
    private static final String m_architecture;
    private static final String m_osName;
    private static final String m_osVersion;
    private static final boolean m_windows;
    private static final boolean m_linux;
    private static final boolean m_osx;
    private static final Logger log;

    private static String stripWhitespace(String mosname) {
        StringBuffer sb = new StringBuffer();
        int size = mosname.length();
        for (int i = 0; i < size; ++i) {
            char ch = mosname.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private SystemUtil() {
    }

    public static final int numProcessors() {
        return m_processors;
    }

    public static final String cpuInfo() {
        return m_cpuInfo;
    }

    public static final String architecture() {
        return m_architecture;
    }

    public static final String operatingSystem() {
        return m_osName;
    }

    public static final String osVersion() {
        return m_osVersion;
    }

    public static final boolean isWindows() {
        return m_windows;
    }

    public static final boolean isLinux() {
        return m_linux;
    }

    public static final boolean isOSX() {
        return m_osx;
    }

    static {
        log = Logger.getLogger(SystemUtil.class);
        m_architecture = System.getProperty("os.arch");
        m_osName = System.getProperty("os.name");
        m_osVersion = System.getProperty("os.version");
        int procs = 0;
        String info = "";
        String prefix = SystemUtil.class.getPackage().getName();
        String name = prefix + "." + SystemUtil.stripWhitespace(m_osName);
        try {
            Class<?> klass = Class.forName(name);
            CPUParser parser = (CPUParser)klass.newInstance();
            procs = parser.numProcessors();
            info = parser.cpuInfo();
        }
        catch (Throwable e) {
            log.warn((Object)("No CPUParser for this platform - looking for class: [" + name + "]"));
            String proc = System.getProperty("os.arch.cpus", "1");
            info = System.getProperty("os.arch.info", m_architecture + " Family n, Model n, Stepping n, Undeterminable");
            procs = Integer.parseInt(proc);
        }
        m_processors = procs;
        m_cpuInfo = info;
        m_windows = SystemUtil.operatingSystem().startsWith("Windows");
        m_linux = SystemUtil.operatingSystem().startsWith("Linux");
        m_osx = SystemUtil.operatingSystem().contains("OS X");
        if (log.isInfoEnabled()) {
            log.info((Object)("architecture: " + m_architecture));
            log.info((Object)("operating system: " + m_osName));
            log.info((Object)("operation system version: " + m_osVersion));
            log.info((Object)("#processors: " + m_processors));
            log.info((Object)("cpu info: " + m_cpuInfo));
        }
    }
}

