/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Configuration;
import org.jooq.ExecuteType;
import org.jooq.Record;
import org.jooq.RecordContext;
import org.jooq.RecordListener;
import org.jooq.RecordListenerProvider;
import org.jooq.conf.InvocationOrder;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.AbstractScope;
import org.jooq.impl.DefaultRecordContext;
import org.jooq.impl.F0;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.Tools;

final class RecordDelegate<R extends Record> {
    private final Configuration configuration;
    private final F0<R> recordSupplier;
    private final Boolean fetched;
    private final RecordLifecycleType type;

    RecordDelegate(Configuration configuration, F0<R> recordSupplier, Boolean fetched) {
        this(configuration, recordSupplier, fetched, RecordLifecycleType.LOAD);
    }

    RecordDelegate(Configuration configuration, F0<R> recordSupplier, Boolean fetched, RecordLifecycleType type) {
        this.configuration = configuration;
        this.recordSupplier = recordSupplier;
        this.fetched = fetched;
        this.type = type;
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, final R record, RecordLifecycleType type) {
        return new RecordDelegate<R>(configuration, new F0<R>(){

            @Override
            public R apply() {
                return record;
            }
        }, null, type);
    }

    final <E extends Exception> R operate(RecordOperation<? super R, E> operation) throws E {
        Exception exception;
        AbstractScope ctx;
        RecordListener[] listeners;
        Record record;
        block32: {
            record = (Record)this.recordSupplier.apply();
            if (this.fetched != null && record instanceof AbstractRecord) {
                ((AbstractRecord)record).fetched = this.fetched;
            }
            RecordListenerProvider[] providers = null;
            listeners = null;
            ctx = null;
            exception = null;
            if (this.configuration != null && (providers = this.configuration.recordListenerProviders()) != null && providers.length > 0) {
                listeners = new RecordListener[providers.length];
                ctx = new DefaultRecordContext(this.configuration, this.executeType(), record);
                for (int i = 0; i < providers.length; ++i) {
                    listeners[i] = providers[i].provide();
                }
            }
            if (listeners != null) {
                block21: for (RecordListener recordListener : ctx == null || ctx.settings().getRecordListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                    switch (this.type) {
                        case LOAD: {
                            recordListener.loadStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                        case REFRESH: {
                            recordListener.refreshStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                        case STORE: {
                            recordListener.storeStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                        case INSERT: {
                            recordListener.insertStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                        case UPDATE: {
                            recordListener.updateStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                        case MERGE: {
                            recordListener.mergeStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                        case DELETE: {
                            recordListener.deleteStart((RecordContext)((Object)ctx));
                            continue block21;
                        }
                    }
                    throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
                }
            }
            if (Tools.attachRecords(this.configuration)) {
                record.attach(this.configuration);
            }
            if (operation != null) {
                try {
                    operation.operate(record);
                }
                catch (Exception e) {
                    exception = e;
                    if (e instanceof ControlFlowSignal) break block32;
                    if (ctx != null) {
                        ((DefaultRecordContext)ctx).exception = e;
                    }
                    if (listeners == null) break block32;
                    for (RecordListener listener : listeners) {
                        listener.exception((RecordContext)((Object)ctx));
                    }
                }
            }
        }
        if (listeners != null) {
            block23: for (RecordListener recordListener : ctx == null || ctx.settings().getRecordListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                switch (this.type) {
                    case LOAD: {
                        recordListener.loadEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                    case REFRESH: {
                        recordListener.refreshEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                    case STORE: {
                        recordListener.storeEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                    case INSERT: {
                        recordListener.insertEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                    case UPDATE: {
                        recordListener.updateEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                    case MERGE: {
                        recordListener.mergeEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                    case DELETE: {
                        recordListener.deleteEnd((RecordContext)((Object)ctx));
                        continue block23;
                    }
                }
                throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
            }
        }
        if (exception != null) {
            throw exception;
        }
        return (R)record;
    }

    private final ExecuteType executeType() {
        return this.type == RecordLifecycleType.LOAD || this.type == RecordLifecycleType.REFRESH ? ExecuteType.READ : ExecuteType.WRITE;
    }

    static enum RecordLifecycleType {
        LOAD,
        REFRESH,
        STORE,
        INSERT,
        UPDATE,
        MERGE,
        DELETE;

    }
}

