/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Comparator;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.CompareCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

final class IsDistinctFrom<T>
extends AbstractCondition {
    private static final long serialVersionUID = 4568269684824736461L;
    private static final Set<SQLDialect> EMULATE_DISTINCT_PREDICATE = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<T> lhs;
    private final Field<T> rhs;
    private final Comparator comparator;

    IsDistinctFrom(Field<T> lhs, Field<T> rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.lhs.getDataType().isEmbeddable() && this.rhs.getDataType().isEmbeddable()) {
            ctx.visit(DSL.row(Tools.embeddedFields(this.lhs)).compare(this.comparator, DSL.row(Tools.embeddedFields(this.rhs))));
        } else if (EMULATE_DISTINCT_PREDICATE.contains((Object)ctx.dialect())) {
            ctx.visit(this.comparator == Comparator.IS_DISTINCT_FROM ? (QueryPartInternal)((Object)DSL.notExists(DSL.select(this.lhs.as("x")).intersect(DSL.select(this.rhs.as("x"))))) : (QueryPartInternal)((Object)DSL.exists(DSL.select(this.lhs.as("x")).intersect(DSL.select(this.rhs.as("x"))))));
        } else if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)ctx.dialect())) {
            ctx.visit(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{not}({0} <=> {1})", this.lhs, this.rhs) : DSL.condition("{0} <=> {1}", this.lhs, this.rhs));
        } else if (SQLDialect.SQLITE == ctx.family()) {
            ctx.visit(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{0} {is not} {1}", this.lhs, this.rhs) : DSL.condition("{0} {is} {1}", this.lhs, this.rhs));
        } else {
            ctx.visit(new CompareCondition(this.lhs, this.rhs, this.comparator));
        }
    }
}

