/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.api;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;

public enum RDFSyntax {
    JSONLD("JSON-LD 1.0", "application/ld+json", ".jsonld", true),
    TURTLE("RDF 1.1 Turtle", "text/turtle", ".ttl", false),
    NQUADS("RDF 1.1 N-Quads", "application/n-quads", ".nq", true),
    NTRIPLES("RDF 1.1 N-Triples", "application/n-triples", ".nt", false),
    RDFA_HTML("HTML+RDFa 1.1", "text/html", ".html", false),
    RDFA_XHTML("XHTML+RDFa 1.1", "application/xhtml+xml", ".xhtml", false),
    RDFXML("RDF 1.1 XML Syntax", "application/rdf+xml", ".rdf", false),
    TRIG("RDF 1.1 TriG", "application/trig", ".trig", true);

    public final String mediaType;
    public final String fileExtension;
    public final boolean supportsDataset;
    private final String name;

    public String toString() {
        return this.name;
    }

    private RDFSyntax(String name, String mediaType, String fileExtension, boolean supportsDataset) {
        this.name = name;
        this.mediaType = mediaType;
        this.fileExtension = fileExtension;
        this.supportsDataset = supportsDataset;
    }

    public static Optional<RDFSyntax> byMediaType(String mediaType) {
        String type = mediaType.toLowerCase(Locale.ENGLISH).split("\\s*[;,]", 2)[0];
        return Arrays.stream(RDFSyntax.values()).filter(t -> t.mediaType.equals(type)).findAny();
    }

    public static Optional<RDFSyntax> byFileExtension(String fileExtension) {
        String ext = fileExtension.toLowerCase(Locale.ENGLISH);
        return Arrays.stream(RDFSyntax.values()).filter(t -> t.fileExtension.equals(ext)).findAny();
    }
}

