/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import java.util.ArrayList;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.cs.Axis;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.GeodeticDatum;
import org.cts.op.ChangeCoordinateDimension;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.CoordinateSwitch;
import org.cts.op.OppositeCoordinate;
import org.cts.op.UnitConversion;
import org.cts.op.projection.Projection;
import org.cts.units.Unit;

public class Geographic2DCRS
extends GeodeticCRS {
    public static final CoordinateSystem LATLON_RR_CS = new CoordinateSystem(new Axis[]{Axis.LATITUDE, Axis.LONGITUDE}, new Unit[]{Unit.RADIAN, Unit.RADIAN});
    public static final CoordinateSystem LONLAT_RR_CS = new CoordinateSystem(new Axis[]{Axis.LONGITUDE, Axis.LATITUDE}, new Unit[]{Unit.RADIAN, Unit.RADIAN});
    public static final CoordinateSystem LATLON_DD_CS = new CoordinateSystem(new Axis[]{Axis.LATITUDE, Axis.LONGITUDE}, new Unit[]{Unit.DEGREE, Unit.DEGREE});
    public static final CoordinateSystem LONLAT_DD_CS = new CoordinateSystem(new Axis[]{Axis.LONGITUDE, Axis.LATITUDE}, new Unit[]{Unit.DEGREE, Unit.DEGREE});
    public static final CoordinateSystem LATLON_GG_CS = new CoordinateSystem(new Axis[]{Axis.LATITUDE, Axis.LONGITUDE}, new Unit[]{Unit.GRAD, Unit.GRAD});
    public static final CoordinateSystem LONLAT_GG_CS = new CoordinateSystem(new Axis[]{Axis.LONGITUDE, Axis.LATITUDE}, new Unit[]{Unit.GRAD, Unit.GRAD});

    public Geographic2DCRS(Identifier identifier, GeodeticDatum datum, CoordinateSystem coordSys) {
        super(identifier, datum, coordSys);
    }

    public Geographic2DCRS(Identifier identifier, GeodeticDatum datum, Unit unit) {
        super(identifier, datum, LATLON_DD_CS);
        this.coordinateSystem = unit == Unit.RADIAN ? LATLON_RR_CS : (unit == Unit.DEGREE ? LATLON_DD_CS : (unit == Unit.GRAD ? LATLON_GG_CS : LATLON_RR_CS));
    }

    public Geographic2DCRS(Identifier identifier, GeodeticDatum datum) {
        super(identifier, datum, LATLON_DD_CS);
    }

    public CoordinateOperation toGeographicCoordinateConverter() {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        for (int i = 0; i < 2; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST) continue;
            ops.add(new OppositeCoordinate(i));
        }
        ops.add(UnitConversion.createUnitConverter(this.getCoordinateSystem().getUnit(0), Unit.RADIAN));
        if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.EAST || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.WEST) {
            ops.add(CoordinateSwitch.SWITCH_LAT_LON);
        }
        ops.add(ChangeCoordinateDimension.TO3D);
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public CoordinateOperation fromGeographicCoordinateConverter() {
        ArrayList<CoordinateOperation> ops = new ArrayList<CoordinateOperation>();
        ops.add(ChangeCoordinateDimension.TO2D);
        if (this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.EAST || this.getCoordinateSystem().getAxis(0).getDirection() == Axis.Direction.WEST) {
            ops.add(CoordinateSwitch.SWITCH_LAT_LON);
        }
        ops.add(UnitConversion.createUnitConverter(Unit.RADIAN, this.getCoordinateSystem().getUnit(0)));
        for (int i = 0; i < 2; ++i) {
            if (this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.SOUTH && this.getCoordinateSystem().getAxis(i).getDirection() != Axis.Direction.WEST) continue;
            ops.add(new OppositeCoordinate(i));
        }
        return new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), ops);
    }

    public Projection getProjection() {
        return null;
    }

    public CoordinateReferenceSystem.Type getType() {
        return CoordinateReferenceSystem.Type.GEOGRAPHIC2D;
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("GEOGCS[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getDatum().toWKT());
        w.append(',');
        w.append(this.getDatum().getPrimeMeridian().toWKT());
        w.append(',');
        w.append(this.getCoordinateSystem().getUnit(0).toWKT());
        for (int i = 0; i < this.getCoordinateSystem().getDimension(); ++i) {
            w.append(',');
            w.append(this.getCoordinateSystem().getAxis(i).toWKT());
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }
}

