/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.DecimalLiteralImpl;
import org.openrdf.model.impl.IntegerLiteralImpl;
import org.openrdf.model.impl.NumericLiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

public class MathUtil {
    public static final int DEFAULT_DECIMAL_EXPANSION_SCALE = 24;
    private static int decimalExpansionScale = 24;

    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        if (leftDatatype == null || !XMLDatatypeUtil.isNumericDatatype((URI)leftDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + leftLit);
        }
        if (rightDatatype == null || !XMLDatatypeUtil.isNumericDatatype((URI)rightDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + rightLit);
        }
        URI commonDatatype = leftDatatype.equals((Object)XMLSchema.DOUBLE) || rightDatatype.equals((Object)XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (leftDatatype.equals((Object)XMLSchema.FLOAT) || rightDatatype.equals((Object)XMLSchema.FLOAT) ? XMLSchema.FLOAT : (leftDatatype.equals((Object)XMLSchema.DECIMAL) || rightDatatype.equals((Object)XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : (op == MathExpr.MathOp.DIVIDE ? XMLSchema.DECIMAL : XMLSchema.INTEGER)));
        try {
            if (commonDatatype.equals((Object)XMLSchema.DOUBLE)) {
                double left = leftLit.doubleValue();
                double right = rightLit.doubleValue();
                switch (op) {
                    case PLUS: {
                        return new NumericLiteralImpl(left + right);
                    }
                    case MINUS: {
                        return new NumericLiteralImpl(left - right);
                    }
                    case MULTIPLY: {
                        return new NumericLiteralImpl(left * right);
                    }
                    case DIVIDE: {
                        return new NumericLiteralImpl(left / right);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + op);
            }
            if (commonDatatype.equals((Object)XMLSchema.FLOAT)) {
                float left = leftLit.floatValue();
                float right = rightLit.floatValue();
                switch (op) {
                    case PLUS: {
                        return new NumericLiteralImpl(left + right);
                    }
                    case MINUS: {
                        return new NumericLiteralImpl(left - right);
                    }
                    case MULTIPLY: {
                        return new NumericLiteralImpl(left * right);
                    }
                    case DIVIDE: {
                        return new NumericLiteralImpl(left / right);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + op);
            }
            if (commonDatatype.equals((Object)XMLSchema.DECIMAL)) {
                BigDecimal left = leftLit.decimalValue();
                BigDecimal right = rightLit.decimalValue();
                switch (op) {
                    case PLUS: {
                        return new DecimalLiteralImpl(left.add(right));
                    }
                    case MINUS: {
                        return new DecimalLiteralImpl(left.subtract(right));
                    }
                    case MULTIPLY: {
                        return new DecimalLiteralImpl(left.multiply(right));
                    }
                    case DIVIDE: {
                        BigDecimal result = null;
                        try {
                            result = left.divide(right, MathContext.UNLIMITED);
                        }
                        catch (ArithmeticException e) {
                            result = left.setScale(MathUtil.getDecimalExpansionScale(), RoundingMode.HALF_UP).divide(right, RoundingMode.HALF_UP);
                        }
                        return new DecimalLiteralImpl(result);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + op);
            }
            BigInteger left = leftLit.integerValue();
            BigInteger right = rightLit.integerValue();
            switch (op) {
                case PLUS: {
                    return new IntegerLiteralImpl(left.add(right));
                }
                case MINUS: {
                    return new IntegerLiteralImpl(left.subtract(right));
                }
                case MULTIPLY: {
                    return new IntegerLiteralImpl(left.multiply(right));
                }
                case DIVIDE: {
                    throw new RuntimeException("Integer divisions should be processed as decimal divisions");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + op);
        }
        catch (NumberFormatException e) {
            throw new ValueExprEvaluationException(e);
        }
        catch (ArithmeticException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    public static int getDecimalExpansionScale() {
        return decimalExpansionScale;
    }

    public static void setDecimalExpansionScale(int decimalExpansionScale) {
        MathUtil.decimalExpansionScale = decimalExpansionScale;
    }
}

