/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl;

import com.bigdata.rdf.graph.IGASStats;
import com.bigdata.rdf.graph.util.GASUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class GASStats
implements IGASStats {
    private final AtomicLong nrounds = new AtomicLong();
    private final AtomicLong frontierSize = new AtomicLong();
    private final AtomicLong nedges = new AtomicLong();
    private final AtomicLong elapsedNanos = new AtomicLong();

    @Override
    public void add(long frontierSize, long nedges, long elapsedNanos) {
        this.nrounds.incrementAndGet();
        this.frontierSize.addAndGet(frontierSize);
        this.nedges.addAndGet(nedges);
        this.elapsedNanos.addAndGet(elapsedNanos);
    }

    @Override
    public void add(IGASStats o) {
        this.nrounds.addAndGet(o.getNRounds());
        this.frontierSize.addAndGet(o.getFrontierSize());
        this.nedges.addAndGet(o.getNEdges());
        this.elapsedNanos.addAndGet(o.getElapsedNanos());
    }

    @Override
    public long getNRounds() {
        return this.nrounds.get();
    }

    @Override
    public long getFrontierSize() {
        return this.frontierSize.get();
    }

    @Override
    public long getNEdges() {
        return this.nedges.get();
    }

    @Override
    public long getElapsedNanos() {
        return this.elapsedNanos.get();
    }

    public String toString() {
        return "nrounds=" + this.getNRounds() + ", fontierSize=" + this.getFrontierSize() + ", ms=" + TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos()) + ", edges=" + this.getNEdges() + ", teps=" + GASUtil.getTEPS(this.getNEdges(), this.getElapsedNanos());
    }
}

