/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.client.SesameHTTPClient;
import org.openrdf.http.client.query.AbstractHTTPUpdate;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.repository.http.HTTPUpdateExecutionException;

public class HTTPUpdate
extends AbstractHTTPUpdate {
    protected final HTTPRepositoryConnection httpCon;

    public HTTPUpdate(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super((HTTPClient)con.getRepository().getHTTPClient(), ql, queryString, baseURI);
        this.httpCon = con;
    }

    public void execute() throws UpdateExecutionException {
        block8: {
            try {
                if (this.httpCon.isAutoCommit()) {
                    SesameHTTPClient client = this.httpCon.getRepository().getHTTPClient();
                    try {
                        client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getBindingsArray());
                        break block8;
                    }
                    catch (UnauthorizedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (QueryInterruptedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (MalformedQueryException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                }
                this.httpCon.scheduleUpdate(this);
            }
            catch (RepositoryException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
        }
    }
}

