/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.util;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class RDFRemover
extends RDFHandlerBase {
    private final RepositoryConnection con;
    private boolean enforceContext;
    private Resource context;

    public RDFRemover(RepositoryConnection con) {
        this.con = con;
        this.enforceContext = false;
    }

    public void enforceContext(Resource context) {
        this.context = context;
        this.enforceContext = true;
    }

    public boolean enforcesContext() {
        return this.enforceContext;
    }

    public Resource getContext() {
        return this.context;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        try {
            if (this.enforceContext) {
                this.con.remove(st.getSubject(), st.getPredicate(), st.getObject(), this.context);
            } else {
                this.con.remove(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
        catch (RepositoryException e) {
            throw new RDFHandlerException((Throwable)((Object)e));
        }
    }
}

