/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.util;

import info.aduna.io.GZipUtil;
import info.aduna.io.ZipUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.ParseErrorLogger;

public class RDFLoader {
    private final ParserConfig config;
    private final ValueFactory vf;

    public RDFLoader(ParserConfig config, ValueFactory vf) {
        this.config = config;
        this.vf = vf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        if (dataFormat == null) {
            dataFormat = Rio.getParserFormatForFileName((String)file.getName());
        }
        FileInputStream in = new FileInputStream(file);
        try {
            this.load(in, baseURI, dataFormat, rdfHandler);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL url, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        URLConnection con = url.openConnection();
        if (dataFormat != null) {
            for (String mimeType : dataFormat.getMIMETypes()) {
                con.addRequestProperty("Accept", mimeType);
            }
        } else {
            Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
            List acceptParams = RDFFormat.getAcceptParams((Iterable)rdfFormats, (boolean)true, null);
            for (String acceptParam : acceptParams) {
                con.addRequestProperty("Accept", acceptParam);
            }
        }
        InputStream in = con.getInputStream();
        if (dataFormat == null) {
            String mimeType;
            mimeType = con.getContentType();
            int semiColonIdx = mimeType.indexOf(59);
            if (semiColonIdx >= 0) {
                mimeType = mimeType.substring(0, semiColonIdx);
            }
            if ((dataFormat = Rio.getParserFormatForMIMEType((String)mimeType)) == null) {
                dataFormat = Rio.getParserFormatForFileName((String)url.getPath());
            }
        }
        try {
            this.load(in, baseURI, dataFormat, rdfHandler);
        }
        finally {
            in.close();
        }
    }

    public void load(InputStream in, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 1024);
        }
        if (ZipUtil.isZipStream((InputStream)in)) {
            this.loadZip(in, baseURI, dataFormat, rdfHandler);
        } else if (GZipUtil.isGZipStream((InputStream)in)) {
            this.load(new GZIPInputStream(in), baseURI, dataFormat, rdfHandler);
        } else {
            this.loadInputStreamOrReader(in, baseURI, dataFormat, rdfHandler);
        }
    }

    public void load(Reader reader, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        this.loadInputStreamOrReader(reader, baseURI, dataFormat, rdfHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadZip(InputStream in, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        ZipInputStream zipIn = new ZipInputStream(in);
        try {
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    RDFFormat format = Rio.getParserFormatForFileName((String)entry.getName(), (RDFFormat)dataFormat);
                    try {
                        FilterInputStream wrapper = new FilterInputStream(zipIn){

                            @Override
                            public void close() {
                            }
                        };
                        this.load(wrapper, baseURI, format, rdfHandler);
                    }
                    catch (RDFParseException e) {
                        String msg = e.getMessage() + " in " + entry.getName();
                        RDFParseException pe = new RDFParseException(msg, e.getLineNumber(), e.getColumnNumber());
                        pe.initCause((Throwable)e);
                        throw pe;
                    }
                    finally {
                        zipIn.closeEntry();
                    }
                }
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            zipIn.close();
        }
    }

    private void loadInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        RDFParser rdfParser = Rio.createParser((RDFFormat)dataFormat, (ValueFactory)this.vf);
        rdfParser.setParserConfig(this.config);
        rdfParser.setParseErrorListener((ParseErrorListener)new ParseErrorLogger());
        rdfParser.setRDFHandler(rdfHandler);
        if (inputStreamOrReader instanceof InputStream) {
            rdfParser.parse((InputStream)inputStreamOrReader, baseURI);
        } else if (inputStreamOrReader instanceof Reader) {
            rdfParser.parse((Reader)inputStreamOrReader, baseURI);
        } else {
            throw new IllegalArgumentException("Must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
        }
    }
}

