/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitorFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.sparql.sse.writers.WriterOp;

public class WriterExpr {
    static final boolean ONELINE = true;

    public static String asString(Expr expr) {
        IndentedLineBuffer b = new IndentedLineBuffer();
        WriterExpr.output((IndentedWriter)b, expr, new SerializationContext());
        return b.asString();
    }

    public static void output(IndentedWriter out, ExprList exprs, SerializationContext sCxt) {
        WriterExpr.output(out, exprs, true, true, sCxt);
    }

    public static void output(IndentedWriter out, ExprList exprs, boolean withTag, boolean unlist, SerializationContext sCxt) {
        if (exprs.size() == 0) {
            out.print("()");
            return;
        }
        if (exprs.size() == 1 && unlist) {
            WriterExpr.output(out, exprs.get(0), sCxt);
            return;
        }
        out.print("(");
        if (withTag) {
            out.print("exprlist");
            out.print(" ");
        }
        for (int i = 0; i < exprs.size(); ++i) {
            if (i != 0) {
                out.print(" ");
            }
            WriterExpr.output(out, exprs.get(i), sCxt);
        }
        out.print(")");
        out.flush();
    }

    private static void outputTail(IndentedWriter out, ExprList exprs, SerializationContext sCxt) {
        for (int i = 0; i < exprs.size(); ++i) {
            out.print(" ");
            WriterExpr.output(out, exprs.get(i), sCxt);
        }
        out.print(")");
    }

    public static void output(IndentedWriter out, Expr expr, SerializationContext sCxt) {
        FmtExprPrefixVisitor fmt = new FmtExprPrefixVisitor(out, sCxt);
        expr.visit(fmt);
        out.flush();
    }

    static class FmtExprPrefixVisitor
    extends ExprVisitorFunction {
        IndentedWriter out;
        SerializationContext context;

        public FmtExprPrefixVisitor(IndentedWriter writer, SerializationContext cxt) {
            this.out = writer;
            this.context = cxt;
        }

        @Override
        protected void visitExprFunction(ExprFunction func) {
            Expr expr;
            this.out.print("(");
            String n = null;
            if (func.getOpName() != null) {
                n = func.getOpName();
            }
            if (n == null) {
                n = func.getFunctionName(this.context);
            }
            this.out.print(n);
            this.out.incIndent();
            int i = 1;
            while ((expr = func.getArg(i)) != null) {
                this.out.print(' ');
                expr.visit(this);
                ++i;
            }
            this.out.print(")");
            this.out.decIndent();
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            this.out.print("(");
            int x = this.out.getCurrentOffset();
            this.out.incIndent(x);
            this.out.print(funcOp.getFunctionName(this.context));
            this.out.incIndent();
            Op op = funcOp.getGraphPattern();
            if (FmtExprPrefixVisitor.oneLine(op)) {
                this.out.print(" ");
            } else {
                this.out.ensureStartOfLine();
            }
            WriterOp.outputNoPrologue(this.out, funcOp.getGraphPattern(), this.context);
            this.out.decIndent();
            this.out.decIndent(x);
            this.out.print(")");
        }

        private static boolean oneLine(Op op) {
            BasicPattern bgp;
            return OpBGP.isBGP(op) && (bgp = ((OpBGP)op).getPattern()).getList().size() <= 1;
        }

        @Override
        public void visit(NodeValue nv) {
            WriterNode.output(this.out, nv.asNode(), this.context);
        }

        @Override
        public void visit(ExprTripleTerm tripleTerm) {
            WriterNode.output(this.out, tripleTerm.getNode(), this.context);
        }

        @Override
        public void visit(ExprNone none) {
            this.out.print("NONE");
        }

        @Override
        public void visit(ExprVar nv) {
            this.out.print(nv.toPrefixString());
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            this.out.print(eAgg.getAggregator().toPrefixString());
        }

        private void endLine() {
            this.out.print(' ');
        }
    }
}

