/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.ItemTransformBase;
import org.apache.jena.sparql.sse.ItemTransformer;
import org.apache.jena.sparql.sse.SSE_Exception;
import org.apache.jena.sparql.sse.builders.BuilderLib;

public class ItemLift {
    public static Item liftItem(Item item) {
        return ItemTransformer.transform(new LiftAll(), item);
    }

    public static Item lowerItem(Item item) {
        return ItemTransformer.transform(new LowerAll(), item);
    }

    private static Item nodeToItem(Node node) {
        return ItemLift.nodeToItem(node, -1, -1);
    }

    private static Item nodeToItem(Node node, int line, int column) {
        String symbol = ItemLift.fn_nodeToSymbol(node);
        if (symbol != null) {
            return Item.createSymbol(symbol, line, column);
        }
        return ItemLift.lowerCompound(node, line, column);
    }

    public static Item liftCompound(Item item) {
        return ItemTransformer.transform(new LiftCompound(), item);
    }

    public static Item lowerCompound(Node node) {
        if (node.isNodeTriple()) {
            Item newItem = ItemLift.lowerCompound(node, -1, -1);
            return newItem;
        }
        return null;
    }

    public static Item lowerCompound(Item item) {
        return ItemTransformer.transform(new LowerCompound(), item);
    }

    private static Item lowerCompound(Node node, int line, int column) {
        if (node.isNodeTriple()) {
            Triple t = node.getTriple();
            Node s = t.getSubject();
            Node p = t.getPredicate();
            Node o = t.getObject();
            ItemList list = new ItemList();
            list.add("qtriple");
            list.add(ItemLift.nodeToItem(s, -1, -1));
            list.add(ItemLift.nodeToItem(p, -1, -1));
            list.add(ItemLift.nodeToItem(o, -1, -1));
            return Item.createList(list, line, column);
        }
        return Item.createNode(node);
    }

    public static Item liftSymbol(Item item) {
        if (!item.isSymbol()) {
            return item;
        }
        String symbol = item.getSymbol();
        Node node = ItemLift.fn_symbolToNode(symbol);
        if (node == null) {
            return item;
        }
        return Item.createNode(node, item.getLine(), item.getColumn());
    }

    public static Item lowerSymbol(Item item) {
        if (!item.isNode()) {
            return item;
        }
        Node node = item.getNode();
        String symbol = ItemLift.fn_nodeToSymbol(node);
        if (symbol == null) {
            return item;
        }
        return Item.createSymbol(symbol, item.getLine(), item.getColumn());
    }

    public static Item lowerSymbol(Node node) {
        String symbol = ItemLift.fn_nodeToSymbol(node);
        if (symbol == null) {
            return null;
        }
        return Item.createSymbol(symbol, -1, -1);
    }

    private static boolean isValidQuotedTriple(Item item) {
        return item.isTagged("qtriple") && item.getList().size() == 4;
    }

    private static boolean isValidQuotedTriple(ItemList list) {
        return list.isTagged("qtriple") && list.size() == 4;
    }

    private static Item liftQuotedTriple(ItemList list, int line, int column) {
        Node n = ItemLift.liftQuotedTripleToNode(list);
        return Item.createNode(n, line, column);
    }

    private static Node liftQuotedTripleToNode(Item item) {
        if (item.isNode()) {
            return item.getNode();
        }
        if (!ItemLift.isValidQuotedTriple(item)) {
            throw new SSE_Exception("Not valid for a quoted triple: " + item.toString());
        }
        return ItemLift.liftQuotedTripleToNode(item.getList());
    }

    private static Node liftQuotedTripleToNode(ItemList list) {
        if (list.isEmpty()) {
            ItemLift.broken(list, "Not a quoted triple (empty list)");
        }
        if (!ItemLift.isValidQuotedTriple(list)) {
            ItemLift.broken(list, "Not valid for a quoted triple: " + list);
        }
        return ItemLift.buildQuotedTriple(list);
    }

    private static Node buildQuotedTriple(ItemList list) {
        Node s = ItemLift.liftQuotedTripleToNode(list.get(1));
        Node p = ItemLift.liftQuotedTripleToNode(list.get(2));
        Node o = ItemLift.liftQuotedTripleToNode(list.get(3));
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        return NodeFactory.createTripleNode((Triple)triple);
    }

    private static Node fn_symbolToNode(String symbol) {
        switch (symbol) {
            case "true": {
                return NodeConst.TRUE;
            }
            case "false": {
                return NodeConst.FALSE;
            }
        }
        return null;
    }

    private static String fn_nodeToSymbol(Node node) {
        if (NodeConst.TRUE.equals((Object)node)) {
            return "true";
        }
        if (NodeConst.FALSE.equals((Object)node)) {
            return "false";
        }
        if (Node.ANY.equals((Object)node)) {
            return "ANY";
        }
        return null;
    }

    private static void broken(ItemLocation location, String msg) {
        BuilderLib.broken(location, msg);
    }

    private static class LiftAll
    extends ItemTransformBase {
        private LiftAll() {
        }

        @Override
        public Item transform(Item item, ItemList list) {
            if (ItemLift.isValidQuotedTriple(list)) {
                return ItemLift.liftQuotedTriple(list, item.getLine(), item.getColumn());
            }
            return super.transform(item, list);
        }

        @Override
        public Item transform(Item item, String symbol) {
            Node node = ItemLift.fn_symbolToNode(symbol);
            if (node != null) {
                return Item.createNode(node, item.getLine(), item.getColumn());
            }
            return super.transform(item, symbol);
        }
    }

    private static class LowerAll
    extends ItemTransformBase {
        private LowerAll() {
        }

        @Override
        public Item transform(Item item, Node node) {
            Item item2 = ItemLift.nodeToItem(node, item.getLine(), item.getColumn());
            if (item2 != null) {
                return item2;
            }
            if (node.isNodeTriple()) {
                return ItemLift.lowerCompound(node, item.getLine(), item.getColumn());
            }
            return super.transform(item, node);
        }
    }

    private static class LiftCompound
    extends ItemTransformBase {
        private LiftCompound() {
        }

        @Override
        public Item transform(Item item, ItemList list) {
            if (ItemLift.isValidQuotedTriple(list)) {
                return ItemLift.liftQuotedTriple(list, item.getLine(), item.getColumn());
            }
            return super.transform(item, list);
        }
    }

    private static class LowerCompound
    extends ItemTransformBase {
        private LowerCompound() {
        }

        @Override
        public Item transform(Item item, Node node) {
            if (node.isNodeTriple()) {
                Item newItem = ItemLift.nodeToItem(node, item.getLine(), item.getColumn());
                return newItem;
            }
            return super.transform(item, node);
        }
    }
}

