/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertValuesStep4;
import org.jooq.InsertValuesStepN;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetFirstStep;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.postgis.Geometry;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeries;

public class TimeSeriesRDBClient<T> {
    private static final Logger LOGGER = LogManager.getLogger(TimeSeriesRDBClient.class);
    private String rdbURL = null;
    private String rdbUser = null;
    private String rdbPassword = null;
    private final Field<T> timeColumn;
    private static final SQLDialect DIALECT = SQLDialect.POSTGRES;
    private static final String DB_TABLE_NAME = "dbTable";
    private static final Field<String> DATA_IRI_COLUMN = DSL.field(DSL.name("dataIRI"), String.class);
    private static final Field<String> TS_IRI_COLUMN = DSL.field(DSL.name("timeseriesIRI"), String.class);
    private static final Field<String> TABLENAME_COLUMN = DSL.field(DSL.name("tableName"), String.class);
    private static final Field<String> COLUMNNAME_COLUMN = DSL.field(DSL.name("columnName"), String.class);
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";
    private static final String CONNECTION_ERROR = "Failed to connect to database";
    private static final String TABLE_NAME_TEMPLATE = "table_name = '%s'";
    private static final String INFORMATION_SCHEMA_TABLES = "information_schema.tables";

    public TimeSeriesRDBClient(Class<T> timeClass) {
        this.timeColumn = DSL.field(DSL.name("time"), timeClass);
    }

    protected String initTimeSeriesTable(List<String> dataIRI, List<Class<?>> dataClass, String tsIRI, Connection conn) {
        return this.initTimeSeriesTable(dataIRI, dataClass, tsIRI, null, conn);
    }

    protected String initTimeSeriesTable(List<String> dataIRI, List<Class<?>> dataClass, String tsIRI, Integer srid, Connection conn) {
        String tsTableName = UUID.randomUUID().toString();
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            String condition = String.format(TABLE_NAME_TEMPLATE, DB_TABLE_NAME);
            if (context.select(DSL.count()).from(INFORMATION_SCHEMA_TABLES).where(condition).fetchOne(0, Integer.TYPE) == 0) {
                this.initCentralTable(context);
            }
            for (String s : dataIRI) {
                if (!this.checkDataHasTimeSeries(s, conn)) continue;
                throw new JPSRuntimeException(this.exceptionPrefix + "<" + s + "> already has an assigned time series instance");
            }
            if (dataIRI.size() != dataClass.size()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Length of dataClass is different from number of data IRIs");
            }
            HashMap<String, String> dataColumnNames = new HashMap<String, String>();
            int i = 1;
            for (String s : dataIRI) {
                dataColumnNames.put(s, "column" + i);
                ++i;
            }
            this.populateCentralTable(tsTableName, dataIRI, dataColumnNames, tsIRI, context);
            this.createEmptyTimeSeriesTable(tsTableName, dataColumnNames, dataIRI, dataClass, srid, conn);
            return tsTableName;
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void addTimeSeriesData(List<TimeSeries<T>> tsList, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        for (TimeSeries<T> ts : tsList) {
            List<String> dataIRI = ts.getDataIRIs();
            try {
                String condition = String.format(TABLE_NAME_TEMPLATE, DB_TABLE_NAME);
                if (context.select(DSL.count()).from(INFORMATION_SCHEMA_TABLES).where(condition).fetchOne(0, Integer.TYPE) == 0) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Central RDB lookup table has not been initialised yet");
                }
                this.checkDataIsInSameTable(dataIRI, context);
                String tsTableName = this.getTimeseriesTableName(dataIRI.get(0), context);
                HashMap<String, String> dataColumnNames = new HashMap<String, String>();
                for (String s : dataIRI) {
                    dataColumnNames.put(s, this.getColumnName(s, context));
                }
                this.populateTimeSeriesTable(tsTableName, ts, dataColumnNames, conn);
            }
            catch (JPSRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
            }
        }
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRI, T lowerBound, T upperBound, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            String condition = String.format(TABLE_NAME_TEMPLATE, DB_TABLE_NAME);
            if (context.select(DSL.count()).from(INFORMATION_SCHEMA_TABLES).where(condition).fetchOne(0, Integer.TYPE) == 0) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Central RDB lookup table has not been initialised yet");
            }
            this.checkDataIsInSameTable(dataIRI, context);
            Table<?> table = this.getTimeseriesTable(dataIRI.get(0), context);
            HashMap<String, Field<Object>> dataColumnFields = new HashMap<String, Field<Object>>();
            for (String string : dataIRI) {
                String columnName = this.getColumnName(string, context);
                Field<Object> field = DSL.field(DSL.name(columnName));
                dataColumnFields.put(string, field);
            }
            ArrayList<Field> columnList = new ArrayList<Field>();
            columnList.add(this.timeColumn);
            for (String data : dataIRI) {
                columnList.add((Field)dataColumnFields.get(data));
            }
            if (lowerBound == null) {
                lowerBound = context.select(DSL.min(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.min(this.timeColumn)).get(0);
            }
            if (upperBound == null) {
                upperBound = context.select(DSL.max(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.max(this.timeColumn)).get(0);
            }
            Result result = context.select(columnList).from((TableLike<?>)table).where(this.timeColumn.between(lowerBound, upperBound)).orderBy(this.timeColumn.asc()).fetch();
            List<T> timeValues = result.getValues(this.timeColumn);
            ArrayList dataValues = new ArrayList();
            for (String data : dataIRI) {
                List column = result.getValues((Field)dataColumnFields.get(data));
                dataValues.add(column);
            }
            return new TimeSeries<T>(timeValues, dataIRI, dataValues);
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRI, Connection conn) {
        return this.getTimeSeriesWithinBounds(dataIRI, null, null, conn);
    }

    public TimeSeries<T> getLatestData(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            Table<?> tsTable = this.getTimeseriesTable(dataIRI, context);
            String columnName = this.getColumnName(dataIRI, context);
            Field<Object> dataField = DSL.field(DSL.name(columnName));
            Result queryResult = context.select(this.timeColumn, dataField).from((TableLike<?>)tsTable).where(dataField.isNotNull()).orderBy(this.timeColumn.desc()).limit(1).fetch();
            List<T> timeValues = queryResult.getValues(this.timeColumn);
            List<Object> dataValues = queryResult.getValues(dataField);
            return new TimeSeries<T>(timeValues, Arrays.asList(dataIRI), Arrays.asList(dataValues));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public TimeSeries<T> getOldestData(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            Table<?> tsTable = this.getTimeseriesTable(dataIRI, context);
            String columnName = this.getColumnName(dataIRI, context);
            Field<Object> dataField = DSL.field(DSL.name(columnName));
            Result queryResult = context.select(this.timeColumn, dataField).from((TableLike<?>)tsTable).where(dataField.isNotNull()).orderBy(this.timeColumn.asc()).limit(1).fetch();
            List<T> timeValues = queryResult.getValues(this.timeColumn);
            List<Object> dataValues = queryResult.getValues(dataField);
            return new TimeSeries<T>(timeValues, Arrays.asList(dataIRI), Arrays.asList(dataValues));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public double getAverage(String dataIRI, Connection conn) {
        return this.getAggregate(dataIRI, AggregateFunction.AVERAGE, conn);
    }

    public double getMaxValue(String dataIRI, Connection conn) {
        return this.getAggregate(dataIRI, AggregateFunction.MAX, conn);
    }

    public double getMinValue(String dataIRI, Connection conn) {
        return this.getAggregate(dataIRI, AggregateFunction.MIN, conn);
    }

    public T getMaxTime(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI, context);
            List<T> queryResult = context.select(DSL.max(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.max(this.timeColumn));
            return queryResult.get(0);
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public T getMinTime(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI, context);
            List<T> queryResult = context.select(DSL.min(this.timeColumn)).from((TableLike<?>)table).fetch(DSL.min(this.timeColumn));
            return queryResult.get(0);
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteRows(String dataIRI, T lowerBound, T upperBound, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI, context);
            context.delete(table).where(this.timeColumn.between(lowerBound, upperBound)).execute();
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteTimeSeries(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            String columnName = this.getColumnName(dataIRI, context);
            String tsTableName = this.getTimeseriesTableName(dataIRI, context);
            String condition = String.format(TABLE_NAME_TEMPLATE, tsTableName);
            if (context.select(DSL.count()).from("information_schema.columns").where(condition).fetchOne(0, Integer.TYPE) > 2) {
                context.alterTable(tsTableName).drop(columnName).execute();
                Table<Record> dbTable = DSL.table(DSL.name(DB_TABLE_NAME));
                context.delete(dbTable).where(DATA_IRI_COLUMN.equal(dataIRI)).execute();
            } else {
                this.deleteTimeSeriesTable(dataIRI, conn);
            }
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteTimeSeriesTable(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            String tsIRI = this.getTimeSeriesIRI(dataIRI, context);
            String tsTableName = this.getTimeseriesTableName(dataIRI, context);
            context.dropTable(DSL.table(DSL.name(tsTableName))).execute();
            Table<Record> dbTable = DSL.table(DSL.name(DB_TABLE_NAME));
            context.delete(dbTable).where(TS_IRI_COLUMN.equal(tsIRI)).execute();
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    protected void deleteAll(Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            String condition = String.format(TABLE_NAME_TEMPLATE, DB_TABLE_NAME);
            if (context.select(DSL.count()).from(INFORMATION_SCHEMA_TABLES).where(condition).fetchOne(0, Integer.TYPE) == 1) {
                Table<Record> dbTable = DSL.table(DSL.name(DB_TABLE_NAME));
                List<String> queryResult = context.selectDistinct(TABLENAME_COLUMN).from((TableLike<?>)dbTable).fetch(TABLENAME_COLUMN);
                if (!queryResult.isEmpty()) {
                    for (String table : queryResult) {
                        context.dropTable(DSL.table(DSL.name(table))).execute();
                    }
                    context.dropTable(dbTable).execute();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException("Error while executing SQL command", e);
        }
    }

    private void initCentralTable(DSLContext context) {
        try (CreateTableColumnStep createStep = context.createTableIfNotExists(DB_TABLE_NAME);){
            createStep.column(DATA_IRI_COLUMN).column(TS_IRI_COLUMN).column(TABLENAME_COLUMN).column(COLUMNNAME_COLUMN).execute();
        }
        context.createIndex().on(DSL.table(DSL.name(DB_TABLE_NAME)), Arrays.asList(DATA_IRI_COLUMN, TS_IRI_COLUMN, TABLENAME_COLUMN, COLUMNNAME_COLUMN)).execute();
    }

    private void populateCentralTable(String tsTable, List<String> dataIRI, Map<String, String> dataColumnNames, String tsIRI, DSLContext context) {
        InsertValuesStep4<Record, String, String, String, String> insertValueStep = context.insertInto(DSL.table(DSL.name(DB_TABLE_NAME)), DATA_IRI_COLUMN, TS_IRI_COLUMN, TABLENAME_COLUMN, COLUMNNAME_COLUMN);
        for (String s : dataIRI) {
            insertValueStep = insertValueStep.values(s, tsIRI, tsTable, dataColumnNames.get(s));
        }
        insertValueStep.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmptyTimeSeriesTable(String tsTable, Map<String, String> dataColumnNames, List<String> dataIRI, List<Class<?>> dataClass, Integer srid, Connection conn) throws SQLException {
        DSLContext context = DSL.using(conn, DIALECT);
        ArrayList<String> additionalGeomColumns = new ArrayList<String>();
        ArrayList classForAdditionalGeomColumns = new ArrayList();
        try (CreateTableColumnStep createStep = null;){
            createStep = context.createTableIfNotExists(tsTable);
            createStep = createStep.column(this.timeColumn);
            for (int i = 0; i < dataIRI.size(); ++i) {
                if (Geometry.class.isAssignableFrom(dataClass.get(i))) {
                    additionalGeomColumns.add(dataColumnNames.get(dataIRI.get(i)));
                    classForAdditionalGeomColumns.add(dataClass.get(i));
                    continue;
                }
                createStep = createStep.column(dataColumnNames.get(dataIRI.get(i)), DefaultDataType.getDataType(DIALECT, dataClass.get(i)));
            }
            createStep.execute();
        }
        context.createIndex().on(DSL.table(DSL.name(tsTable)), this.timeColumn).execute();
        if (!additionalGeomColumns.isEmpty()) {
            this.addGeometryColumns(tsTable, additionalGeomColumns, classForAdditionalGeomColumns, srid, conn);
        }
    }

    private void addGeometryColumns(String tsTable, List<String> columnNames, List<Class<?>> dataTypes, Integer srid, Connection conn) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("alter table \"%s\" ", tsTable));
        for (int i = 0; i < columnNames.size(); ++i) {
            sb.append(String.format("add %s geometry(%s", columnNames.get(i), dataTypes.get(i).getSimpleName()));
            if (srid != null) {
                sb.append(String.format(", %d)", srid));
            } else {
                sb.append(")");
            }
            if (i != columnNames.size() - 1) {
                sb.append(", ");
                continue;
            }
            sb.append(";");
        }
        String sql = sb.toString();
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }

    private void populateTimeSeriesTable(String tsTable, TimeSeries<T> ts, Map<String, String> dataColumnNames, Connection conn) throws SQLException {
        DSLContext context = DSL.using(conn, DIALECT);
        List<String> dataIRIs = ts.getDataIRIs();
        Table<Record> table = DSL.table(DSL.name(tsTable));
        ArrayList<Field<T>> columnList = new ArrayList<Field<T>>();
        columnList.add(this.timeColumn);
        for (String data : dataIRIs) {
            columnList.add(DSL.field(DSL.name(dataColumnNames.get(data))));
        }
        ArrayList<Integer> rowsWithMatchingTime = new ArrayList<Integer>();
        InsertValuesStepN<Record> insertValueStep = context.insertInto(table, columnList);
        int numRowsWithoutMatchingTime = 0;
        for (int i = 0; i < ts.getTimes().size(); ++i) {
            if (!this.checkTimeRowExists(tsTable, ts.getTimes().get(i), context)) {
                Object[] newValues = new Object[dataIRIs.size() + 1];
                newValues[0] = ts.getTimes().get(i);
                for (int j = 0; j < ts.getDataIRIs().size(); ++j) {
                    newValues[j + 1] = ts.getValues(dataIRIs.get(j)).get(i);
                }
                insertValueStep = insertValueStep.values(newValues);
                ++numRowsWithoutMatchingTime;
                continue;
            }
            rowsWithMatchingTime.add(i);
        }
        if (numRowsWithoutMatchingTime != 0) {
            try (PreparedStatement statement = conn.prepareStatement(insertValueStep.toString());){
                statement.executeUpdate();
            }
        }
        Iterator iterator = rowsWithMatchingTime.iterator();
        while (iterator.hasNext()) {
            int rowIndex = (Integer)iterator.next();
            UpdateSetFirstStep<Record> updateStep = context.update(table);
            for (int i = 0; i < ts.getDataIRIs().size(); ++i) {
                String dataIRI = ts.getDataIRIs().get(i);
                if (i == ts.getDataIRIs().size() - 1) {
                    updateStep.set(DSL.field(DSL.name(dataColumnNames.get(dataIRI))), ts.getValues(dataIRI).get(rowIndex)).where(this.timeColumn.eq(ts.getTimes().get(rowIndex)));
                    try (PreparedStatement statement = conn.prepareStatement(updateStep.toString());){
                        statement.executeUpdate();
                        continue;
                    }
                }
                updateStep.set(DSL.field(DSL.name(dataColumnNames.get(dataIRI))), ts.getValues(dataIRI).get(rowIndex));
            }
        }
    }

    boolean checkDataHasTimeSeries(String dataIRI, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        Table<Record> table = DSL.table(DSL.name(DB_TABLE_NAME));
        return context.fetchExists(DSL.selectFrom(table).where(DATA_IRI_COLUMN.eq(dataIRI)));
    }

    boolean checkDataHasTimeSeries(String dataIRI) {
        boolean bl;
        block8: {
            Connection conn = this.getConnection();
            try {
                DSLContext context = DSL.using(conn, DIALECT);
                Table<Record> table = DSL.table(DSL.name(DB_TABLE_NAME));
                bl = context.fetchExists(DSL.selectFrom(table).where(DATA_IRI_COLUMN.eq(dataIRI)));
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JPSRuntimeException(String.format("Error making connection to %s", this.rdbURL), e);
                }
            }
            conn.close();
        }
        return bl;
    }

    private void checkDataIsInSameTable(List<String> dataIRI, DSLContext context) {
        String tsIRI = this.getTimeSeriesIRI(dataIRI.get(0), context);
        if (dataIRI.size() > 1) {
            for (int i = 1; i < dataIRI.size(); ++i) {
                String curTsIRI = this.getTimeSeriesIRI(dataIRI.get(i), context);
                if (curTsIRI.contentEquals(tsIRI)) continue;
                throw new JPSRuntimeException(this.exceptionPrefix + "Provided data is not within the same RDB table");
            }
        }
    }

    private String getTimeSeriesIRI(String dataIRI, DSLContext context) {
        try {
            Table<Record> table = DSL.table(DSL.name(DB_TABLE_NAME));
            List<String> queryResult = context.select(TS_IRI_COLUMN).from((TableLike<?>)table).where(DATA_IRI_COLUMN.eq(dataIRI)).fetch(TS_IRI_COLUMN);
            return queryResult.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "<" + dataIRI + "> does not have an assigned time series instance");
        }
    }

    private String getColumnName(String dataIRI, DSLContext context) {
        try {
            Table<Record> table = DSL.table(DSL.name(DB_TABLE_NAME));
            List<String> queryResult = context.select(COLUMNNAME_COLUMN).from((TableLike<?>)table).where(DATA_IRI_COLUMN.eq(dataIRI)).fetch(COLUMNNAME_COLUMN);
            return queryResult.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "<" + dataIRI + "> does not have an assigned time series instance");
        }
    }

    private String getTimeseriesTableName(String dataIRI, DSLContext context) {
        try {
            Table<Record> table = DSL.table(DSL.name(DB_TABLE_NAME));
            List<String> queryResult = context.select(TABLENAME_COLUMN).from((TableLike<?>)table).where(DATA_IRI_COLUMN.eq(dataIRI)).fetch(TABLENAME_COLUMN);
            return queryResult.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "<" + dataIRI + "> does not have an assigned time series instance");
        }
    }

    private Table<?> getTimeseriesTable(String dataIRI, DSLContext context) {
        String tableName = this.getTimeseriesTableName(dataIRI, context);
        return DSL.table(DSL.name(tableName));
    }

    private boolean checkTimeRowExists(String tsTableName, T time, DSLContext context) {
        try {
            return context.fetchExists(DSL.selectFrom(DSL.table(DSL.name(tsTableName))).where(this.timeColumn.eq(time)));
        }
        catch (DataAccessException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error in checking if a row exists for a given time value");
        }
    }

    protected double getAggregate(String dataIRI, AggregateFunction aggregateFunction, Connection conn) {
        DSLContext context = DSL.using(conn, DIALECT);
        try {
            Table<?> table = this.getTimeseriesTable(dataIRI, context);
            String columnName = this.getColumnName(dataIRI, context);
            Field<Double> columnField = DSL.field(DSL.name(columnName), Double.class);
            switch (aggregateFunction) {
                case AVERAGE: {
                    return context.select(DSL.avg(columnField)).from((TableLike<?>)table).fetch(DSL.avg(columnField)).get(0).doubleValue();
                }
                case MAX: {
                    return context.select(DSL.max(columnField)).from((TableLike<?>)table).fetch(DSL.max(columnField)).get(0);
                }
                case MIN: {
                    return context.select(DSL.min(columnField)).from((TableLike<?>)table).fetch(DSL.min(columnField)).get(0);
                }
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Aggregate function " + aggregateFunction.name() + " not valid!");
        }
        catch (JPSRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + "Error while executing SQL command", e);
        }
    }

    public void setRdbURL(String rdbURL) {
        this.rdbURL = rdbURL;
    }

    public String getRdbURL() {
        return this.rdbURL;
    }

    public void setRdbUser(String user) {
        this.rdbUser = user;
    }

    public String getRdbUser() {
        return this.rdbUser;
    }

    public void setRdbPassword(String password) {
        this.rdbPassword = password;
    }

    protected void loadRdbConfigs(String filepath) throws IOException {
        block9: {
            File file = new File(filepath);
            if (!file.exists()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "No properties file found at specified filepath: " + filepath);
            }
            try (FileInputStream input = new FileInputStream(file);){
                Properties prop = new Properties();
                prop.load(input);
                if (!prop.containsKey("db.url")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"db.url=<rdb_url>\" ");
                }
                this.setRdbURL(prop.getProperty("db.url"));
                if (!prop.containsKey("db.user")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"db.user=<rdb_username>\" ");
                }
                this.setRdbUser(prop.getProperty("db.user"));
                if (prop.containsKey("db.password")) {
                    this.setRdbPassword(prop.getProperty("db.password"));
                    break block9;
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"db.password=<rdb_password>\" ");
            }
        }
    }

    protected String initTimeSeriesTable(List<String> dataIRI, List<Class<?>> dataClass, String tsIRI) {
        return this.initTimeSeriesTable(dataIRI, dataClass, tsIRI, (Integer)null);
    }

    protected String initTimeSeriesTable(List<String> dataIRI, List<Class<?>> dataClass, String tsIRI, Integer srid) {
        String string;
        block8: {
            Connection conn = this.getConnection();
            try {
                string = this.initTimeSeriesTable(dataIRI, dataClass, tsIRI, srid, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return string;
    }

    protected void addTimeSeriesData(List<TimeSeries<T>> tsList) {
        try (Connection conn = this.getConnection();){
            this.addTimeSeriesData(tsList, conn);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRI, T lowerBound, T upperBound) {
        TimeSeries<T> timeSeries;
        block8: {
            Connection conn = this.getConnection();
            try {
                timeSeries = this.getTimeSeriesWithinBounds(dataIRI, lowerBound, upperBound, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return timeSeries;
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRI) {
        return this.getTimeSeriesWithinBounds(dataIRI, null, null);
    }

    public TimeSeries<T> getLatestData(String dataIRI) {
        TimeSeries<T> timeSeries;
        block8: {
            Connection conn = this.getConnection();
            try {
                timeSeries = this.getLatestData(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return timeSeries;
    }

    public TimeSeries<T> getOldestData(String dataIRI) {
        TimeSeries<T> timeSeries;
        block8: {
            Connection conn = this.getConnection();
            try {
                timeSeries = this.getOldestData(dataIRI, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return timeSeries;
    }

    public double getAverage(String dataIRI) {
        double d;
        block8: {
            Connection conn = this.getConnection();
            try {
                d = this.getAggregate(dataIRI, AggregateFunction.AVERAGE, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return d;
    }

    public double getMaxValue(String dataIRI) {
        double d;
        block8: {
            Connection conn = this.getConnection();
            try {
                d = this.getAggregate(dataIRI, AggregateFunction.MAX, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return d;
    }

    public double getMinValue(String dataIRI) {
        double d;
        block8: {
            Connection conn = this.getConnection();
            try {
                d = this.getAggregate(dataIRI, AggregateFunction.MIN, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage());
                    throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
                }
            }
            conn.close();
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getMaxTime(String dataIRI) {
        try (Connection conn = this.getConnection();){
            T t = this.getMaxTime(dataIRI, conn);
            return t;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getMinTime(String dataIRI) {
        try (Connection conn = this.getConnection();){
            T t = this.getMinTime(dataIRI, conn);
            return t;
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    protected void deleteRows(String dataIRI, T lowerBound, T upperBound) {
        try (Connection conn = this.getConnection();){
            this.deleteRows(dataIRI, lowerBound, upperBound, conn);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    protected void deleteTimeSeries(String dataIRI) {
        try (Connection conn = this.getConnection();){
            this.deleteTimeSeries(dataIRI, conn);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    protected void deleteTimeSeriesTable(String dataIRI) {
        try (Connection conn = this.getConnection();){
            this.deleteTimeSeriesTable(dataIRI, conn);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    protected void deleteAll() {
        try (Connection conn = this.getConnection();){
            this.deleteAll(conn);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new JPSRuntimeException(this.exceptionPrefix + CONNECTION_ERROR, e);
        }
    }

    protected Connection getConnection() throws SQLException {
        try {
            Class.forName("org.postgresql.Driver");
            return DriverManager.getConnection(this.rdbURL, this.rdbUser, this.rdbPassword);
        }
        catch (ClassNotFoundException e) {
            throw new JPSRuntimeException(this.exceptionPrefix + "driver not found", e);
        }
    }

    protected static enum AggregateFunction {
        AVERAGE,
        MAX,
        MIN;

    }
}

