/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfLiteral;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class ValuesPattern
implements GraphPattern {
    public static final String ILLEGAL_INIT_ARG_ERROR_MSG = "Illegal init argument: Each value pair MUST contain all variables, received: ";
    public static final String ILLEGAL_VALUEPAIR_ERROR_MSG = "Illegal value pair to add: The added value pair MUST contain the same number of values as existing value pairs, existing: ";
    List<Variable> variables;
    List<RdfObject[]> valuePairs;

    public ValuesPattern(Variable variable, RdfObject ... valuesForSingleVariable) {
        this.variables = Arrays.asList(variable);
        this.valuePairs = new ArrayList<RdfObject[]>();
        for (RdfObject value : valuesForSingleVariable) {
            this.valuePairs.add(new RdfObject[]{value});
        }
    }

    public ValuesPattern(Variable variable, List<RdfObject> valuesListForSingleVariable) {
        this.variables = Arrays.asList(variable);
        this.valuePairs = new ArrayList<RdfObject[]>();
        for (RdfObject value : valuesListForSingleVariable) {
            this.valuePairs.add(new RdfObject[]{value});
        }
    }

    public ValuesPattern(List<Variable> variables, List<RdfObject[]> valuePairsForMultipleVariables) {
        this.variables = variables;
        if (!valuePairsForMultipleVariables.stream().allMatch(arr -> ((RdfObject[])arr).length == variables.size())) {
            throw new JPSRuntimeException(ILLEGAL_INIT_ARG_ERROR_MSG + this.formulateStringForVariables(variables) + this.formulateStringForValuePairs(valuePairsForMultipleVariables));
        }
        this.valuePairs = new ArrayList<RdfObject[]>(valuePairsForMultipleVariables);
    }

    public ValuesPattern(Variable ... variables) {
        this.variables = Arrays.asList(variables);
        this.valuePairs = new ArrayList<RdfObject[]>();
    }

    public void addValuePairForMultipleVariables(RdfObject ... valuePairForMultipleVariables) {
        if (valuePairForMultipleVariables.length != this.variables.size()) {
            throw new JPSRuntimeException(ILLEGAL_VALUEPAIR_ERROR_MSG + this.getQueryString() + ", received: " + this.formulateStringForValuePairs(valuePairForMultipleVariables));
        }
        this.valuePairs.add(valuePairForMultipleVariables);
    }

    @Override
    public String getQueryString() {
        return this.formulateStringForVariables(this.variables) + " " + this.formulateStringForValuePairs(this.valuePairs);
    }

    private String formulateStringForVariables(List<Variable> variables) {
        StringBuilder sb = new StringBuilder();
        sb.append(" VALUES ( ");
        sb.append(variables.stream().map(v -> v.getQueryString()).collect(Collectors.joining(" ")));
        sb.append(" ) ");
        return sb.toString();
    }

    private String formulateStringForValuePairs(List<RdfObject[]> valuePairs) {
        StringBuilder sb = new StringBuilder();
        sb.append(" { ");
        for (RdfObject[] valuePair : valuePairs) {
            sb.append("(");
            sb.append(Arrays.stream(valuePair).map(v -> this.getQueryStringEscapeInfinityAndNaN((RdfObject)v)).collect(Collectors.joining(" ")));
            sb.append(") ");
        }
        sb.append("} ");
        return sb.toString();
    }

    private String formulateStringForValuePairs(RdfObject ... values) {
        ArrayList<RdfObject[]> pair = new ArrayList<RdfObject[]>();
        pair.add(values);
        return this.formulateStringForValuePairs(pair);
    }

    private String getQueryStringEscapeInfinityAndNaN(RdfObject v) {
        if (v instanceof RdfLiteral.NumericLiteral) {
            if (v.equals(Rdf.literalOf(Double.POSITIVE_INFINITY))) {
                return "\"Infinity\"^^<http://www.w3.org/2001/XMLSchema#double>";
            }
            if (v.equals(Rdf.literalOf(Double.NEGATIVE_INFINITY))) {
                return "\"-Infinity\"^^<http://www.w3.org/2001/XMLSchema#double>";
            }
            if (v.equals(Rdf.literalOf(Double.NaN))) {
                return "\"NaN\"^^<http://www.w3.org/2001/XMLSchema#double>";
            }
        }
        return v.getQueryString();
    }
}

