/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.algebra;

import info.aduna.iteration.CloseableIteration;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.federation.evaluation.InsertBindingSetCursor;

public class OwnedTupleExpr
extends UnaryTupleOperator {
    private final RepositoryConnection owner;
    private TupleQuery query;
    private Map<String, String> variables;

    public OwnedTupleExpr(RepositoryConnection owner, TupleExpr arg) {
        super(arg);
        this.owner = owner;
    }

    public RepositoryConnection getOwner() {
        return this.owner;
    }

    public void prepare(QueryLanguage queryLn, String qry, Map<String, String> bindings) throws RepositoryException, MalformedQueryException {
        assert (this.query == null);
        this.query = this.owner.prepareTupleQuery(queryLn, qry);
        this.variables = bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Dataset dataset, BindingSet bindings) throws QueryEvaluationException {
        InsertBindingSetCursor rval = null;
        if (this.query != null) {
            try {
                TupleQuery tupleQuery = this.query;
                synchronized (tupleQuery) {
                    for (String name : this.variables.keySet()) {
                        if (bindings.hasBinding(name)) {
                            Value value = bindings.getValue(name);
                            this.query.setBinding(this.variables.get(name), value);
                            continue;
                        }
                        this.query.removeBinding(this.variables.get(name));
                    }
                    this.query.setDataset(dataset);
                    TupleQueryResult result = this.query.evaluate();
                    rval = new InsertBindingSetCursor((CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return rval;
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther((QueryModelNode)this);
    }

    public String getSignature() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.owner.toString();
    }
}

