/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipFileDocumentSource
extends OWLOntologyDocumentSourceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZipFileDocumentSource.class);
    private final File file;

    public GZipFileDocumentSource(File is) {
        super("file:ontology", null, null);
        this.file = is;
    }

    public GZipFileDocumentSource(File stream, IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(documentIRI, format, mime);
        this.file = stream;
    }

    @Override
    public Optional<InputStream> getInputStream() {
        try {
            return OWLAPIPreconditions.optional(new GZIPInputStream(new FileInputStream(this.file)));
        }
        catch (IOException e) {
            LOGGER.error("File cannot be found or opened", (Throwable)e);
            this.failedOnStreams.set(true);
            return OWLAPIPreconditions.emptyOptional();
        }
    }
}

