/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLDisjointUnionAxiom
extends OWLClassAxiom {
    public OWLDisjointUnionAxiom getAxiomWithoutAnnotations();

    @Override
    default public Stream<?> components() {
        return Stream.of(this.getOWLClass(), this.classExpressions(), this.annotations());
    }

    @Override
    default public Stream<?> componentsWithoutAnnotations() {
        return Stream.of(this.getOWLClass(), this.classExpressions());
    }

    @Override
    default public Stream<?> componentsAnnotationsFirst() {
        return Stream.of(this.annotations(), this.getOWLClass(), this.classExpressions());
    }

    @Override
    default public int hashIndex() {
        return 43;
    }

    public OWLClass getOWLClass();

    @Deprecated
    default public Set<OWLClassExpression> getClassExpressions() {
        return OWLAPIStreamUtils.asSet(this.classExpressions());
    }

    public Stream<OWLClassExpression> classExpressions();

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom();

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom();

    @Override
    default public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    default public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    default public AxiomType<?> getAxiomType() {
        return AxiomType.DISJOINT_UNION;
    }
}

