/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class MakeClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    public MakeClassesMutuallyDisjoint(OWLDataFactory dataFactory, Collection<? extends OWLClassExpression> classExpressions, boolean usePairwiseDisjointAxioms, OWLOntology targetOntology) {
        super(dataFactory);
        OWLAPIPreconditions.checkNotNull(classExpressions, "classExpressions cannot be null");
        OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null");
        this.generateChanges(classExpressions, usePairwiseDisjointAxioms, targetOntology);
    }

    private void generateChanges(Collection<? extends OWLClassExpression> classExpressions, boolean usePairwiseDisjointAxioms, OWLOntology targetOntology) {
        if (usePairwiseDisjointAxioms) {
            OWLAPIStreamUtils.pairs(classExpressions).forEach(v -> this.addChange(new AddAxiom(targetOntology, this.df.getOWLDisjointClassesAxiom((OWLClassExpression)v.i, (OWLClassExpression)v.j))));
        } else {
            this.addChange(new AddAxiom(targetOntology, this.df.getOWLDisjointClassesAxiom(classExpressions)));
        }
    }
}

